<?php

/*
  
  File: mailbox.php3
  $Author: chuck $
  $Revision: 1.73 $
  $Date: 1998/10/01 18:19:50 $
  
  IMP: Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
  
  This code is under the GNU Public License
  See the file COPYING in this directory
  
*/
  
  require( './lib/imp.lib.php3' );      /* IMPlib is the IMP function library */
  require( './lib/mimetypes.php3' );    /* Mime types lib */
  require( './lib/setcookie.lib' );     /* cookie setting functions */
  require( './config/defaults.php3' );  /* Defaults configuration file */

  if( $default->ssl->enabled )    { include( "./lib/ssl_lib.php3" ); }

  error_reporting($default->error_level);  /* set error level from imp.lib.php3   */
  
  /* Set or read cookies */
  if (isset($actionID) && ($actionID == IMP_LOGIN) && !$default->ssl->enabled ) {
    if(empty($user)) $user="";       $user    = setuser($user);
    if(empty($pass)) $pass="";       $pass    = setpass($pass);
    if(empty($server)) $server="";   $server  = setsrvr($server);
    if(empty($port)) $port="";       $port    = setport($port);
    if(empty($folders)) $folders=""; $folders = setfldr($folders);
  } else {
    $user    = getuser();
    $pass    = getpass();
    $server  = getsrvr();
    $port    = getport();
    $folders = getfldr();
  }
  
  if( !isset($mailbox) ) $mailbox = 'INBOX';
  
  $current_mbox = eregi_replace("{$server}$folders*", '', $mailbox);
  if (strlen("$default->personal_folders")>0)
    $current_mbox = eregi_replace("$default->personal_folders", '',$current_mbox);
  
  header('Expires: 120');         /* make the page expire in 2 minutes   */
  
  /* only proceed on a valid login */
  $mbox = validate_login($server, $port, $mailbox, $user, $pass);
  
  if( !isset($punct) ) $punct="";

  /* Run through the action handlers */
  
  if (isset($actionID)) {
    if (isset($indices) && !is_array($indices)) { $indices = Array($indices); }
    
    switch ($actionID) {
      case NO_ACTION:
        status( "Mailbox: $current_mbox" );
        break;
      
      case DELETE_MESSAGES:
        if ($indices && $mailbox) {
	  for ($i = 0; $i < count($indices); $i++) {
	    if (!(imap_delete($mbox, $indices[$i]))) {
	      status( "Mailbox: $current_mbox: Error: Message Deletion Failed", 'red' );
	    }
	  }
	  if (!isset($status_sent) || !$status_sent) {
	    if ($i != 1) { $punct = 's'; }
	    status( "Mailbox: $current_mbox: Deleted $i Message$punct" );
	  }
	}
        if (!$status_sent) { status( "Mailbox: $current_mbox: Error: Message Deletion Failed" , 'red'); }
	break;
      
      case UNDELETE_MESSAGES:
        if ($mailbox && $indices) {
	  for ($i = 0; $i < count($indices); $i++) {
	    if (!(imap_undelete($mbox, $indices[$i]))) {
              status( "Mailbox: $current_mbox: Error: Message Undeletion Failed" , 'red');
	    }
	  }
	  if (!$status_sent) {
	    if ($i != 1) { $punct = 's'; }
	    status( "Mailbox: $current_mbox: Undeleted $i Message$punct" );
	  }
	}
        if (!$status_sent) { status( "Mailbox: $current_mbox: Error: Message Undeletion Failed", 'red' ); }
	break;
      
      case MOVE_MESSAGES:
        if ($target && $indices) {
	  $msg_list = implode($indices, ',');
	  if (! (imap_mail_move($mbox, $msg_list, $target)) ) {
	    status( "Mailbox: $current_mbox: Error: Message Move Failed", 'red' );
	  } else {
	    if ( count($indices) != 1) { $punct = 's'; }
	    status( "Mailbox: $current_mbox: Moved " . count($indices) . " Message$punct  to $target" );
	  }
	}
        if (!$status_sent) { status( "Mailbox: $current_mbox: Error: Message Move Failed", 'red' ); }
	break;
      
      case COPY_MESSAGES:
        if ($target && $indices) {
	  $msg_list = implode($indices, ',');
	  if (!(imap_mail_copy($mbox, $msg_list, $target)) ) {
            status( "Mailbox: $current_mbox: Error: Message Copy Failed", 'red' );
	  } else {
	    if ( count($indices) != 1) { $punct = 's'; }
	    status( "Mailbox: $current_mbox: Copied " . count($indices) . " Message$punct to $target" );
	  }
	}
        if (!$status_sent) { status( "Mailbox: $current_mbox: Error: Message Copy Failed", 'red' ); }
	break;
      
      case EXPUNGE_MAILBOX:
        if ($mailbox) {
	  if (!(imap_expunge($mbox))) {
            status( "Mailbox: $current_mbox: Error: Mailbox Expunge Failed", 'red' );
	  } else {
	    status( "Mailbox: $current_mbox: Expunged Mailbox" );
	  }
	}
        if (!$status_sent) { status( "Mailbox: $current_mbox: Error: Mailbox Expunge Failed", 'red' ); }
	break;
      
      case IMP_LOGIN:
        echo '<script language="JavaScript">
	      if (parent.impmenu) {
	        parent.impmenu.location="menu.php3?menu=' . IMPMENU_MAIN . '";
	      }
	      if (parent.impfolder) {
	        parent.impfolder.location="select.php3";
	      }
	      </script>
	';
        status( "Mailbox: $current_mbox" );
	break;
    }
  } else { status( "Mailbox: $current_mbox" ); }
  
  $title = "Index of $current_mbox";
  $no_table_frame = false;
  $sidebar = false;
  require( "$default->include_dir/generic-header.inc");
  $nummsgs = imap_num_msg($mbox);
  
  if ($nummsgs > $default->max_messages_page) {
    $page_count = ceil($nummsgs/$default->max_messages_page);
    
    /* Figure out which page to display */
    if ($page) {
      # don't need to do anything here
    } elseif ($start) {
      $page = ceil($start/$default->max_messages_page);
    } elseif ($mailbox == 'INBOX' && $actionID == IMP_LOGIN) {
      $page = $page_count;
    } else {
      $page = 1;
    }
    $begin = ($page - 1) * $default->max_messages_page + 1;
    
    $end = $begin + $default->max_messages_page - 1;
    if ($end > $nummsgs) { $end = $nummsgs; }
    
    if ($page == 1) {
      $pages_first = "<img src=\"$default->graphics_url/first-grey.gif\" border=\"0\" alt=\"\">";
      $pages_prev  = "<img src=\"$default->graphics_url/prev-grey.gif\" border=\"0\" alt=\"\">";
    } else {
      $prev = $page - 1;
      $pages_first = "<a href=\"$default->root_url/mailbox.php3?mailbox=$mailbox&page=1\"><img src=\"$default->graphics_url/first.gif\" border=\"0\" alt=\"first page\"></a>";
      $pages_prev  = "<a href=\"$default->root_url/mailbox.php3?mailbox=$mailbox&page=$prev\"><img src=\"$default->graphics_url/prev.gif\" border=\"0\" alt=\"prev page\"></a>";
    }
    
    if ($page == $page_count) {
      $pages_last = "<img src=\"$default->graphics_url/last-grey.gif\" border=\"0\" alt=\"\">";
      $pages_next = "<img src=\"$default->graphics_url/next-grey.gif\" border=\"0\" alt=\"\">";
    } else {
      $next = $page + 1;
      $pages_last = "<a href=\"$default->root_url/mailbox.php3?mailbox=$mailbox&page=$page_count\"><img src=\"$default->graphics_url/last.gif\" border=\"0\" alt=\"last page\"></a>";
      $pages_next = "<a href=\"$default->root_url/mailbox.php3?mailbox=$mailbox&page=$next\"><img src=\"$default->graphics_url/next.gif\" border=\"0\" alt=\"next page\"></a>";
    }
    
  } else {
    $begin = 1;
    $end   = $nummsgs;
  }
  
  
  $check=imap_check($mbox);
  require( "$default->include_dir/mailbox.php3-header.inc");
  
  $options = mailbox_list($mailbox, true);
  
  require( "$default->include_dir/mailbox.php3-navbar1.inc");
  require( "$default->include_dir/mailbox.php3-actions.inc");
  require( "$default->include_dir/mailbox.php3-message_headers.inc");
  
  for ($i=$begin; $i <= $end; $i++) {
    if (! imap_ping($mbox) ) {
      $mbox = imap_open("{$server:$port}$mailbox",$user,$pass);
    }
    
    $h=imap_header($mbox,$i);
    
    $dat = chop(substr(htmlentities($h->date), 0, 11));
    $frm = chop(htmlentities(decode_mime_string($h->fromaddress)));
    $sub = chop(htmlentities(decode_mime_string($h->subject)));
    
    if ($dat == '') { $dat = '&nbsp;'; }
    if ($frm == '') { $frm = '&nbsp;'; }
    if ($sub == '') { $sub = '[no subject]'; }

    $icons = array();
    
    if( $default->fetch_mime_info ) {
      $flag = array();
      $structure = imap_fetchstructure($mbox,$i);
      $num_parts = @count($structure->parts);
      
      $bodypart = 1;
      $j = 0;
      if (is_array( $structure->parts ) && $num_parts > 0) {
        if( $num_parts > 9 ) $num_parts = 9;
	
	while ($j <= $num_parts) {
          if( is_object( $structure->parts[$j] ) ) {
	    $mime = new mime_part_data;
	    $mime->set_imap_data( $mailbox, $i, $j );
	    $mime->parse( $structure->parts[$j] );
	    if( $mime->type_text != "text" || $mime->subtype != "plain" || $j != 0 ) {
	      if( isset($icons[$mime->text]) )
		$icons[$mime->text]["count"]++;
	      else {
		$icons[$mime->text]["display"] = $mime->img_tag();
		$icons[$mime->text]["count"] = 1;
	      }
	    }
	  }
	  $j++;
	}
	for( reset($icons); $key=key($icons); next($icons) ) {
	  $tmp = $icons[$key]["display"];
	  if( $icons[$key]["count"] > 1 ) 
	    $tmp .= "<subscript><b>".$icons[$key]["count"]."</b></subscript>";
	  $tmp .= "\n";
	  $flag[] = $tmp;
	}

      } else {
	
	/* Only one part in message, check for an attachment */
	$mime = new mime_part_data;
	$mime->set_imap_data( $mailbox, $i, $j );
	$mime->parse( $structure );
	if( $mime->type_text != "text" || $mime->subtype != "plain" )
	  $flag[] = $mime->img_tag();
      }

    }
    
    if ($h->Unseen == 'U') {
      include( "$default->include_dir/mailbox.php3-message_newsummary.inc" );
    } elseif ($h->Deleted == 'D') {
      include( "$default->include_dir/mailbox.php3-message_delsummary.inc" );
    } else {
      include( "$default->include_dir/mailbox.php3-message_summaries.inc" );
    }
  }
  
  require( "$default->include_dir/mailbox.php3-message_footers.inc" );
  require( "$default->include_dir/mailbox.php3-actions.inc" );
  require( "$default->include_dir/mailbox.php3-navbar2.inc" );
  require( "$default->include_dir/generic-footer.inc" );
  require( "$default->include_dir/mailbox.php3-javascript.inc" );
?>
