# mysql_create.sql
#
# This script creates the databases used within the horde system.
# The horde, database is the common database within which all of the
# rest of the databses derive their functionality off of.

# you can simply direct this file to mysql as STDIN:
# mysql (user/pass/host args) < mysql_create.sql



CREATE DATABASE horde;

\r horde

# Create the primary user table
CREATE TABLE horde_user_table (
	horde_user_id					BIGINT 	NOT NULL AUTO_INCREMENT,
	horde_user_name				TEXT 		NOT NULL DEFAULT '',
	horde_password					TEXT,
   login_deny                 INT( 1 ) NOT NULL DEFAULT 0,
	PRIMARY KEY( horde_user_id ),
	INDEX( horde_user_id )
	);

# create the imap server table
CREATE TABLE imap_server_table (
	horde_user_id					BIGINT 	NOT NULL,
	user_name						TEXT,
	password							TEXT,
	server							TEXT,
	server_type_id					TEXT,
	PRIMARY KEY( horde_user_id ),
	INDEX( horde_user_id )
	);

# create the document configuration table
CREATE TABLE document_config_table (
	document_id						BIGINT 	NOT NULL AUTO_INCREMENT,
	horde_user_id					BIGINT 	NOT NULL DEFAULT '',
	body_bg_color					TEXT,
	body_background_file			TEXT,
	body_text_color				TEXT,
	body_link_color				TEXT,
	body_vlink_color				TEXT,
	body_alink_color				TEXT,
	PRIMARY KEY( document_id ),
	KEY( horde_user_id ),
	INDEX( horde_user_id, document_id )
	);
	
# Now create the imp specific tables.
CREATE DATABASE imp;
\r imp

# imp signitures
CREATE TABLE imp_signature_table (
	horde_user_id					BIGINT 	NOT NULL,
	signature						TEXT,
	PRIMARY KEY( horde_user_id ),
	INDEX( horde_user_id )
);
	
# done!
