<?php

/*
   
   File: lib/imp.lib.php3
   $Author: chuck $
   $Revision: 1.3 $
   $Date: 1998/09/29 17:41:44 $
   
   MimeLib: Copyright 1998 Patrick C. Audley paudley@blackcat.ca
   
   This code is under the GNU Public License
   See the file COPYING in this directory
   
*/

class mime_part {
  var $type;
  var $subtype;
  var $content;
  var $transfer_encoding;
  var $description;
  var $name;

  function mime_part() {
    $this->type = "TEXT";
    $this->subtype = "PLAIN";
    $this->content = "";
    $this->transfer_encoding = "7bit";
    $this->description = "";
    $this->name = "";
  }

  function parse_full_type( $fulltype ) {
    $arr = split("/",$fulltype);
    $this->type = $arr[0];
    $this->subtype = $arr[1];
  }

  function header() {
    $message  = "Content-Type: ".strtolower($this->type."/".$this->subtype);
    if( $this->name != "" ) $message .= "; name=\"".$this->name."\";";
    $message .= "\n";
    $message .= "Content-Transfer-Encoding: $this->transfer_encoding\n";
    if( $this->description != "" ) $message .= "Content-Description: $this->description;\n";
    return $message;
  }
}

class mime_message {

  var $separator;
  var $_init;

  var $end_parts;
  var $begin_parts;
  var $middle_parts;

  function mime_message() {
    $this->begin_parts = array();
    $this->middle_parts = array();
    $this->end_parts = array();
    $this->_init = false;
  }
 
  function init( $unique_text ) {
    $this->separator = "-MOQ".(string)date('U').md5($unique_text);
    $this->_init = true;
  }

  function parts() {
    return @count($this->begin_parts) + @count($this->middle_parts) + @count($this->end_parts);
  }    

  function header() {
    $hdrs = "MIME-Version: 1.0\n";
    if( $this->parts() > 1 ) {
      $hdrs .= 'Content-Type: multipart/mixed; boundary="' . $this->separator . '"'.";\n";
    } else {
      $hdrs .= $this->only_part_header();
    }
    return $hdrs;
  }

  function _only_part() {    
    if( @count($this->begin_parts) > 0 ) { return $this->begin_parts[0]; }
    if( @count($this->middle_parts) > 0 ) { return $this->middle_parts[0]; }
    if( @count($this->end_parts) > 0 ) { return $this->end_parts[0]; }
  }
  function only_part_body() { $part = $this->_only_part(); return $part->contents; }
  function only_part_header() { $part = $this->_only_part(); return $part->header(); }
  
  function add_begin_part( $part ) { $this->begin_parts[] = $part; }
  function add_middle_part( $part ) { $this->middle_parts[] = $part; }
  function add_end_part( $part ) { $this->end_parts[] = $part; }

  function generate() {
    $c_begin = @count($this->begin_parts);
    $c_middle = @count($this->middle_parts);
    $c_end = @count($this->end_parts);
    $message = "";
    
    if( $c_begin+$c_middle+$c_end == 1 ) {
      /* There is only one part, no need to make a multi-part message */
      $message = $this->only_part_body();

    } else {
      /* Output the multipart stuff.. */
      $message = "This message is in MIME format.\n";

      for( $i=0; $i<$c_begin; $i++ ) {
	$part = $this->begin_parts[$i];
	$message .= "\n--$this->separator\n";
        $message .= $part->header();
	$message .="\n";
	$message .= $part->contents;
      }
      for( $i=0; $i<$c_middle; $i++ ) {
	$part = $this->middle_parts[$i];
	$message .= "\n--$this->separator\n";
        $message .= $part->header();
	$message .="\n";
	$message .= $part->contents;
      }
      for( $i=0; $i<$c_end; $i++ ) {
	$part = $this->end_parts[$i];
	$message .= "\n--$this->separator\n";
        $message .= $part->header();
	$message .="\n";
	$message .= $part->contents;
      }

      $message .= "\n--$this->separator\n";
    }
    return $message;
  }
}

?>
