<?php

/*
   
   File : lib/imp.lib.php3
   $Author: paudley $
   $Revision: 1.73 $
   $Date: 1998/10/01 02:03:26 $
   
   IMP : Copyright 1998 Charles J. Hagenbuch chuck@osmos.ml.org
   
   This code is under the GNU Public License
   See the file COPYING in this directory

*/

/* Bring in the horde libary for the base and other classes needed */
require( "./lib/horde.lib.php3" );

$temp_ver = '$Revision: 1.73 $'; /* grap imp's version from the cvs version stamp */
$temp_ver = ereg_replace( 'Revision: ', '', $temp_ver );
$temp_ver = ereg_replace( '\$', '', $temp_ver );

define("IMP_VERSION",  $temp_ver );

/* Define all of the actions */

define("NO_ACTION",         0);
define("DELETE_MESSAGES",   1);
define("UNDELETE_MESSAGES", 2);
define("MOVE_MESSAGES",     3);
define("COPY_MESSAGES",     4);
define("EXPUNGE_MAILBOX",   5);
define("IMP_LOGIN",         6);
define("REPLY",             7);
define("REPLY_ALL",         8);
define("FORWARD",           9);
define("DELETE_FOLDER",    10);
define("CREATE_FOLDER",    11);
define("RENAME_FOLDER",    12);
define("DOWNLOAD_ATTACH",  13);
define("VIEW_ATTACH",      14);
define("DELETE_ADDR",      15);
define("ADD_ADDR",         16);
define("UPDATE_ADDR",      17);
define("UPDATE_SIGNATURE", 18);
define("SEND_MESSAGE",     19);
define("POSTPONE_MESSAGE", 20);
define("VIEW_SOURCE",      21);

/* MENU Modes */
define("IMPMENU_DORMANT",  100 );
define("IMPMENU_MAIN",     200 );
define("IMPMENU_BLANK",    999 );

/* IMP CONFIGURATOR MODES */
define("IMPCFGMGR_WRITE_CONFIG", 800 );

/* Define the logging events */
define("SENT",			51);
define("DELETED",		52);
define("SENT_SIGNED",		53);
define("RECEIVED",		54);
define("RECEIVED_SIGNED",	55);


/* Classes */

# should there be something here?


/* Initialization */
$default = new ImpDefaults();              /* Create and initialize Defaults Object */


/* Functions */

/* function to wrap text at $wrap, semi-gracefully */

function fill_paragraphs($text, $wrap=80, $break="\n", $delim='+') {
  $lines = explode("\n", $text);
  
  $i = 0;
  
  while ($i < sizeof ($lines)) {
    if (strlen($lines[$i]) < $wrap) {
      $result[count($result)] = $lines[$i];
      $i++;
    } else {
      $result[count($result)] = substr($lines[$i], 0, $wrap);
      $lines[$i] = $delim . substr($lines[$i], $wrap, strlen($lines[$i]) - $wrap);
    }
  }
  return implode($break, $result);
}


/* function to decode a MIME-encoded string, returns the original string, if not MIME */

function decode_mime_string ($string) {
if ( eregi( "=?([A-Z,0-9,-]+)?([A-Z,0-9,-]+)?([A-Z,0-9,-,=,_]+)?=",  $string)) {
    $coded_strings = split("=\?", $string);
    $counter = 1;
    $string = '';
  while ($counter < sizeof($coded_strings)) {
    $elements = split ("\?", $coded_strings[$counter]);
    if ( eregi("Q", $elements[1] ) ) {
      $elements[2] = eregi_replace("=([A-F,0-9]{2})", "%\\1", $elements[2]);
      $string .= urldecode($elements[2]);
      } else {
      $elements[2] = ereg_replace("=", "", $elements[2]); 
      if ($elements[2]) { $string .= base64_decode($elements[2]); }
      }
    $counter++;
    }
  $string = ereg_replace("_", " ", $string);
  }
  return $string;
}


/* obtain a (possibly filtered) list of mailboxes */

function mailbox_list ($filter = '', $header = false, $options = '') {
  global $mbox, $server, $folders, $mailbox, $default, $user;
  
  $mboxes = imap_listmailbox($mbox, "{$server}", "$folders*");
  sort($mboxes);
  
  if ($header) { $options .= '<option value="">selected mail to:</option>'; }
  
  for ($i = 0; $i < count($mboxes); $i++) {
    $label = eregi_replace("{$server}$folders+", '', $mboxes[$i]);
    $value = "$folders$label";
    if (strcmp('INBOX',$label) == 0) 
      $Inbox = 1;
    else
      if (strlen($default->personal_folders)>0)
	if (strcmp($default->personal_folders,
		   substr($label,0,strlen($default->personal_folders)))==0)
	  $label = eregi_replace("$default->personal_folders",'', $label);
       
    if ($filter != $value && (($label[0] != '.') || $default->show_dotfiles)) { $options .= "    <option value=\"$value\">$label</option>\n"; }
  }
  if (empty($Inbox)) $Inbox=false;
  if (!$Inbox && ($filter!='INBOX')) { $options = '    <option value="INBOX">Inbox</option>' . $options; }
  
  return $options;
}

/* make sure the user has a valid login; if so, return an imap stream */

function validate_login($server, $port, $mailbox, $user, $pass) {
  global $sidebar;
  
  if (! ($mbox = imap_open("{$server:$port}$mailbox", $user, $pass)) ) {
    if (!$sidebar) {
      echo '<script language=javascript>
            window.location="login.php3?reason=timeout";
  	    </script>
	    ';
    }
  }
  return $mbox;
}


/* cookie functions
 * 
 * the strtr in the cookie functions is NOT encryption. SSL is
 * relied on for the encryption - if you do not use SSL, NONE of this is
 * secure. this is just in case cookie values get displayed on the screen,
 * or something similar. If someone has a better way, please let me know.
 */

$trans_fwd = ' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+=-';
$trans_bck = '1234567890-=ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+abcdefghijklm nopqrstuvwxyz';

/* cookie retrieval functions */

function getuser() {
  global $chuckmIMPuser, $trans_fwd, $trans_bck, $default;

  if ( $default->ssl->enabled ) {
    global $ssl;
    if ( $ssl->process() ) {
      return $ssl->ssl_user;
    }
  }
  return strtr($chuckmIMPuser, $trans_bck, $trans_fwd);
}

function getpass() {
  global $chuckmIMPpass, $trans_fwd, $trans_bck, $default;
  
  if ( $default->ssl->enabled ) {
    global $ssl;
    if ($ssl->process()) {
      return $ssl->ssl_pass;
    }
  }
  return strtr($chuckmIMPpass, $trans_bck, $trans_fwd);
}

function getsrvr() {
  global $default, $chuckmIMPsrvr, $trans_fwd, $trans_bck;
  
  if ( $default->ssl->enabled ) {
    global $ssl;
    if ( $ssl->process() ) {
      return $ssl->ssl_server;
    }
  }
  if (isset($chuckmIMPsrvr)) {
    return strtr($chuckmIMPsrvr, $trans_bck, $trans_fwd);
  } else {
    return $default->server;
  }
}

function getport() {
  global $default, $chuckmIMPport, $trans_fwd, $trans_bck;
  
  if ( $default->ssl->enabled ) {
    global $ssl;
    if ( $ssl->process() ) {
      return $ssl->ssl_port;
    }
  }
  if (isset($chuckmIMPport)) {
    return strtr($chuckmIMPport, $trans_bck, $trans_fwd);
  } else {
    return $default->port;
  }
}

function getfldr() {
  global $default, $chuckmIMPfldr, $trans_fwd, $trans_bck;
  
  if ( $default->ssl->enabled ) {
    global $ssl;
    if ( $ssl->process() ) {
      return $ssl->ssl_folder;
    }
  }
  if (isset($chuckmIMPfldr)) {
    return strtr($chuckmIMPfldr, $trans_bck, $trans_fwd);
  } else {
    return $default->folders;
  }
}


function status($message, $status='green') {
  global $status_sent;
  
  echo '<script language="JavaScript">';
  echo 'if (parent.impstatus) {';
  echo 'parent.impstatus.location="status.php3?message=' . urlencode($message) . "&status=$status" . '";';
  echo '}';
  echo '</script>';
  
  $status_sent = true;
}

function log_event( $user, $target, $event, $log, $md5 ) {
  global $default;
  if( ! $default->log->enabled ) { return true; }

  /*   FIXME!!  The database routines need to be
   *   moved to mysql.lib.php3 and made generic.
   */

  if( !($db = mysql_pconnect("localhost","www-data")) ) {
    status("Error in LOG __FILE__(__LINE__): DB not found."); 
    return false;
  }
  if( !($dbs = mysql_select_db("imp",$db)) ) {
    status("Error in LOG __FILE__(__LINE__): Can't select DB."); 
    return false;
  }
  $res = mysql_db_query("imp","insert into imp_log values ('$user',now(),$event,'$target','$log','$md5')",$db);
  if( !$res ) {
    status( "error committing log information");
  }
  mysql_free_result($res);  
}


/* end imp.lib */

?>
