<?php

/*
   File: lib/db/mysql.lib.php3
   $Author: zerodiv $
   $Revision: 1.6 $
   $Date: 1998/10/01 23:42:35 $

   IMP : Copyright 1998 Charles J. Hagenbuch chuck@osmos.ml.org

   This code is under the GNU Public License
   See the file COPYING in this directory

File Purpose:
This file contains the database support for mysql.

*/

/*
Defines for return status codes.
*/
define( "DB_INVALID_USERNAME_PASSWORD",     10001 );    /* Invalid username / password   */
define( "DB_CONNECT_FAILED",                10002 );    /* Connection Failed - Unknown   */
define( "DB_DATABASE_FAILED",               10003 );    /* Select Database Failed        */
define( "DB_INSERT_FAILED",                 10004 );    /* Insert into database failed   */
define( "DB_UPDATE_FAILED",                 10005 );    /* Update into databse failed    */
define( "DB_DELETE_FAILED",                 10006 );    /* Delete from database failed   */
define( "DB_QUERY_FAILED",                  77777 );    /* Database query failed         */
define( "DB_NO_MATCH_FOUND",                66666 );    /* No match found - 0 rows       */
define( "DB_NOT_CONNECTED",                 88888 );    /* Database not available        */

/*
HordeMysqlDb : Defines all the interaction with the base
   horde tables.
*/

class HordeMysqlDb {
   var $user_name;
   var $password;
   var $server_name;
   var $server_port;
   var $db_name;
   var $db_connect_string;
   var $db_connection_handle;
   var $persistent_mode;
   var $connection_init;

   /* The following object api MUST be within all database objects */
   var $User;
   var $Grant;
   var $ImapServer;

   Function HordeMysqlDb() {

      $this->user_name              = '';
      $this->password               = '';
      $this->server_name            = 'localhost';
      $this->server_port            = '';
      $this->db_name                = '';
      $this->db_connect_string      = '';
      $this->db_connection_handle   = undef;
      $this->persistent_mode        = true;
      $this->connection_init        = false;

      /* The following object api MUST be within all database objects */
      $this->User                   = new HordeMysqlDb_User;

      } /* END HordeMysqlDb() */

   /* CascadeConnection() -   Cascades the connection handle down to 
                              the subobjects */
   Function CascadeConnection() {
      $this->User->db_connection_handle   = $this->db_connection_handle;
      } /* END CascadeConnection() */

   Function BuildConnectString() {

      $this->db_connect_string = $this->server_name;

      if ( $this->server_port != '' ) {
         $this->db_connect_string .= ':' . $this->port_name;
         }

      } /* END BuildConnectionString */

   Function CreateConnection() {

      $this->BuildConnectString();

      if (
         $this->persistent_mode == true &&
         $this->connection_init == false ) {

         /* Open the connection to the database */
         if ( !(
               $this->db_connection_handle =
               mysql_pconnect(
                  $this->db_connect_string,
                  $this->user_name,
                  $this->password )
               ) ) {
            return array( false, DB_INVALID_USERNAME_PASSWORD );
            }

         /* Switch to the horde database for that connection */
         if ( !( $db_test = mysql_select_db( $this->db_connection_handle, $this->db_name ) )  ) { 
            return array( false, DB_DATABASE_FAILED );
            }
         $this->CascadeConnection();
         return array( $this->db_connection_handle );

         }

      if ( 
         $this->persistent_mode == true &&
         $this->connection_init == true ) {
         $this->CascadeConnection();
         return array( $this->db_connection_handle );
         } 

      } /* END CreateConnection() */

      
   } /* END HordeMysqlDb class */

class HordeMysqlDb_User {
   var $connection_handle;

   /*
   Function       : HordeMysqlDbUser
   Parameters     : NONE
   Return Values  : NONE
   Purpose        : To instanciate a instance of the HordeMysqlDb object.
   */
   Function HordeMysqlDb_User() {
      $this->connection_handle = undef;
      } /* END HordeMysqlDb_User() */

   /*
   Function       : Verify
   Parameters     : (HordeUser)
   Return Values  :                    
      TRUE                             
      FALSE, Error Id
   Purpose        : To verify a users access to the horde system.
   */
   Function Verify( $ThisUser ) {

      /* Make sure the database handle is available */
      if ( $this->connection_handle == undef ) {
         return array( false, DB_NOT_CONNECTED );
         }

      } /* END Verify() */

   /*
   Function       : Get
   Parameters     : (HordeUser)
   Return Values  :                       
      (HordeUser) $ThisUser               
      FALSE, ERROR_ID
   Purpose        : Finds a user with the attributes that are passed in.
   */
   Function Get( $ThisUser ) {

      /* Make sure the database handle is available */
      if ( $this->connection_handle == undef ) {
         return array( false, DB_NOT_CONNECTED );
         }

      /* Build up the query string */
      $query_string = '';
      $query_string .= 'SELECT
                        user_id, user_name, user_password,
                        login_deny FROM horde_user_table';
      $more_than_one = false;

      if ( $ThisUser->user_id ) {
         $query_string .= 'user_id = ' . $ThisUser->user_id;
         $more_than_one = true;
         }

      if ( $more_than_one == true ) { $query_string .= ' AND'; }

      if ( $ThisUser->user_name ) {
         $query_string .= 'user_name = "' . $user_name . '"';
         $more_than_one = true;
         }

      if ( $more_than_one == true ) { $query_string .= ' AND'; }

      if ( $ThisUser->password ) {
         $query_string .= 'password = "' . $password . '"';
         $more_than_one = true;
         }

      $query_string .= ';';

      if ( ! $result_handle = mysql_db_query( $this->connection_handle, $query_string ) )
         {
         return array( false, DB_QUERY_FAILED );
         }
      $ResultObj = new HordeUser;
      if ( ! (
               list( $user_id, $user_name, $password, $login_deny )
               = mysql_fetch_row( $result_handle )) ){
         return array( false, DB_NO_MATCH_FOUND );
         }

      } /* END Get() */

   /*
   Function       : Add
   Parameters     : (HordeUser)
   Return Values  :                       
      TRUE                                
      FALSE, ERROR_ID
   Purpose        : Adds a user with the attributes defined in the
                    $ThisUser that is passed in.
   */
   Function Add( $ThisUser ) {

      /* Make sure the database handle is available */
      if ( $this->connection_handle == undef ) {
         return array( false, DB_NOT_CONNECTED );
         }

      } /* END Add() */

   /*
   Function       : Modify
   Parameters     : (HordeUser->user_id), (HordeUser) 
   Return Values  :                       
      TRUE                                
      FALSE, ERROR_ID
   Purpose        : Modify the user_id(x)'s member data to contain
                    the new data provided within the
                    passed in object
   */
   Function Modify( $user_id, $ThisUser ) {

      /* Make sure the database handle is available */
      if ( $this->connection_handle == undef ) {
         return array( false, DB_NOT_CONNECTED );
         }

      } /* END Modify */

   /*
   Function       : Delete
   Parameters     : (HordeUser->user_id)
   Return Values  :
      TRUE
      FALSE, ERROR_ID
   Purpose        : To delete a user_id(x)'s data from the database.
   */
   Function Delete( $user_id ) {

      /* Make sure the database handle is available */
      if ( $this->connection_handle == undef ) {
         return array( false, DB_NOT_CONNECTED );
         }

      } /* END Delete */

   /*
   Function       : ListAll
   Parameters     : NONE
   Return Values  : Array of HordeUser objects
   Purpose        : To list all of the users within the system.
   */
   Function ListAll() {

      /* Make sure the database handle is available */
      if ( $this->connection_handle == undef ) {
         return array( false, DB_NOT_CONNECTED );
         }

      } /* END List All */

   }

?>
