<?php

/*
  
  File: config/defaults.php3
  $Author: chuck $
  $Revision: 1.37 $
  $Date: 1998/10/01 15:20:24 $
  
  IMP: Copywrite 1998 Charles J. Hagenbuch chuck@osmos.ml.org
  
  This code is under the GNU Public License
  See the file COPYING in this directory
  
*/


/* Imp Defaults Configuration File

This file is for configuring imp defaults.

The file itself is built around modifying the $default object
that contains sub objects for documents and user flags, options
and other items.

Several configurations are included but are commented out with
block comments like this block of text.
*/

/* Html Configuration

To configure the html for any of the documents you will need
to place values in the ImpDocument class for it.

ImpDocument Class :

class ImpDocument {
   - Html Configuration Elements - 
   var $bg_file;                    - url to a background image -
   var $bg_color;                   - background color -
   var $text_color;                 - text color -
   var $link_color;                 - link color -
   var $vlink_color;                - vlink color -
   var $alink_color;                - alink color -
   - Rest of class is ommited for clarity see
   lib/imp.lib.php3 to see all of it -

Sample:
   Lets modify the main body pages background color to white :
   $default->body->bg_color = '#ffffff'; 
*/

/* set theme colors */
$default->dark_bg                   = '#002266';
$default->light_bg                  = '#e9e9e9';
$default->text_on_light             = '#000000';
$default->text_on_dark              = '#ffffff';
$default->text_bg                   = '#ffffff';
$default->item_bg                   = '#ffffcc';
$default->new_item_bg               = '#eeeeff';
$default->del_item_bg               = '#cccccc';
$default->nav_bg                    = '#dcdcdc';

$default->body->bg_color            = $default->light_bg;
$default->body->bg_file             = '';
$default->body->text_color          = $default->text_on_light;
$default->body->link_color          = '#0000ff';
$default->body->vlink_color         = '#0000aa';
$default->body->alink_color         = '#0000ff';
$default->sidebar->bg_color         = $default->dark_bg;
$default->sidebar->text_color       = $default->text_on_dark;
$default->sidebar->link_color       = '#e0e0e0';
$default->sidebar->vlink_color      = '#dddddd';
$default->sidebar->alink_color      = '#ffffff';
$default->sidebar->logo             = 'impsmall.gif';


/* Server Specific Configuration

Since a lot of the configuration options are changing / being added
I (zero) have not written much documentation for them. I will in
the future. I provided the sample configs to show what chuck and
I use.

When changing the server specific configuration you address the
ImpDefault object directly. Here is the imp default object:

class ImpDefaults {
  - Local Configuration -
  var $localhost;
      - your local host name -

  - Html Configuration -
  
  - impmain frame colors -
  var $body;    
      - ImpDocument : configures the impmain frame colors - 
  
  - impmenu (sidebar) frame colors -
  var $sidebar;
      - ImpDocument : configures the impmenu frame colors -

  - URL Configuraton -
  var $graphics_url;
      - imp specfic graphics -

  var $root_url;
      - imp base url -
  
  - IMAP Configuration -
  var $server;
      - default IMAP server to connect to -
  var $folders;
      - default directory to look in for mail folders -
  
  var $secure;
      - Use SSL for cookies if it is a secure connection -
  
  - Imp Server Configuration -
  var $user_change_server;
      - set false to force use of the default server -
  var $user_change_folder;
      - set false to force use of the default folder dir -
  var $user_change_from;
      - set false to force use of the system default from address -
  
  - Imp Client Configuration -
  var $max_messages_page;
      - max number of messages to display in one page in mailbox.php3 -

  - Imp Folder Configuration -
  var $user_home_dirs;
      - possible user home directories for LOCAL users only.
*/

/****************************************************************
                         W A R N I N G
 
 You MUST set $default->localhost to the name of the webserver.
 
 Cookies will be horribly broken otherwise.
 
 ****************************************************************/

/* Sample Configurations */

/* -- Alpha.jccc.net Configuration -- */
$default->root_url                  = '/devel';
$default->graphics_url              = $default->root_url . '/graphics';
$default->server                    = 'alpha.jccc.net';  
$default->port                      = 143;
$default->folders                   = 'mail/';
$default->secure                    = true;
$default->user_change_server        = false;
$default->user_change_folder        = false;
$default->user_change_from          = false;
$default->user_use_filemgr          = false;
$default->user_use_addressbook      = false;
$default->show_dotfiles             = false;
$default->error_level               = 1;
$default->path_to_sendmail          = '/usr/sbin/sendmail';
$default->path_to_ispell            = '/usr/bin/ispell';
$default->use_db                    = true;
$default->db_lib                    = 'lib/mysql.lib.php3';
$default->include_dir               = './templates';
$default->localhost                 = 'alpha.jccc.net';
$default->user_home_dirs            = Array( "/home", "/homec" );
$default->ssl->snoop_dn             = false;
$default->ssl->client_auth_required = false;
$default->log->enabled              = false;
$default->cyrus->enabled            = false;
$default->personal_folders          = '';

/* -- horde.org Configuration --
$default->root_url                  = '/cvs/imp';
$default->graphics_url              = $default->root_url . '/graphics';
$default->server                    = 'wso.williams.edu';
$default->port                      = 143;
$default->folders                   = 'mail/';
$default->secure                    = true;
$default->user_change_server        = true;
$default->user_change_folder        = true;
$default->user_change_from          = true;
$default->user_use_filemgr          = false;
$default->user_use_addressbook      = true;
$default->show_dotfiles             = false;
$default->error_level               = 1;
$default->path_to_sendmail          = '/usr/sbin/sendmail';
$default->path_to_ispell            = '/usr/bin/ispell';
$default->db_lib                    = 'lib/mysql.lib.php3';
$default->use_db                    = true;
$default->include_dir               = './templates';
$default->localhost                 = 'web.horde.org';
$default->user_home_dirs            = Array( '/home' );
$default->ssl->snoop_dn             = false;
$default->ssl->client_auth_required = false;
$default->log->enabled              = false;
$default->cyrus->enabled            = false;
$default->personal_folders          = '';
*/

/* -- valkyrie.blackcat.ca Configuration -- *
 *  Support for SSL certs and Cyrus imapd   *
 * ---------------------------------------- *
$default->root_url                  = '/imp-cvs';
$default->graphics_url              = $default->root_url . '/graphics';
$default->sidebar->logo             = '../../ec/spim_logo.gif';
$default->server                    = 'staff.gt.ca';
$default->port                      = 143;
$default->folders                   = '';
$default->secure                    = true;
$default->user_change_server        = false;
$default->user_change_folder        = false;
$default->user_change_from          = false;
$default->user_use_filemgr          = false;
$default->user_use_addressbook      = true;
$default->path_to_ispell            = '/usr/bin/ispell';
$default->show_dotfiles             = false;
$default->error_level               = 15;
$default->path_to_imap              = '';
$default->path_to_sendmail          = '/usr/sbin/sendmail';
$default->use_db                    = true;
$default->db_lib                    = 'lib/mysql.lib.php3';
$default->include_dir               = './templates';
$default->localhost                 = 'valkyrie.blackcat.ca';
$default->user_home_dirs            = Array( "/home", "/homec" );
$default->ssl->enabled              = true;
$default->ssl->check_cert           = true;
$default->ssl->snoop_dn             = true;
$default->ssl->client_auth_required = true;
$default->ssl->issuers              = array("/C=CA/ST=BC/L=Vancouver/O=GT Group Telecom Inc./OU=Ecommerce/CN=admin valkyrie 01/Email=webmaster@blackcat.ca"=>true,
					    "/C=CA/ST=BC/L=Vancouver/O=GT Group Telecom Inc./OU=eCommerce/CN=SPIM v1.3/Email=admin@ec.gt.ca"=>true);
$default->log->enabled              = true;
$default->cyrus->enabled            = true;
$default->cyrus->auto_create        = true;
$default->cyrus->admin_user         = "root";
$default->cyrus->admin_pass         = "********";
$default->personal_folders          = '';
$gt = true;
*/

/* set the db lib to the dummy driver if use_db is false */
if (!$default->use_db) { $default->db_lib = 'lib/dummy.lib.php3'; }

/* set personal_folders to 'INBOX.' if whe're using Cyrus IMAP 
 *
 * Note: if you are using cyrus, only set this to something else
 *       you really know what it does..
 */ 
if ($default->cyrus->enabled) { $default->personal_folders = 'INBOX.'; }

/*  Custom mime_types config:
 *
 *  Below is an example of a custom mime type.  This could be used to process
 * the contents and display them....  For example, the second function below
 * display all gifs/jpgs that are 10k or smaller.
 *
 */

  $mime_actions["application/x-imp-data"] = array("action" => "function",
						  "function" => "mime_action_ximpdata",
						  "view" => false,
						  "download" => false,
						  "icon" => "mime_broken.gif" );
  $mime_actions["image/"] = array("action" => "function",
				  "function" => "mime_action_images",
				  "view" => true,
				  "download" => true,
				  "icon" => "mime_image.gif" );

  function mime_action_ximpdata( $mime ) {
    global $default;
    $ret = "\n<table vspace=0 hspace=0 cellpadding=0 cellspacing=0 border=0><tr><td>$mime->icon Data &nbsp $nbsp</td>";    
    return $ret."</tr></table>\n";
  }

  function mime_action_images( $mime ) {
    $ret = "<table vspace=0 hspace=0 cellpadding=0 cellspacing=0 border=0><tr><td>";
    $mime->action["action"] = "default";
    $ret .= $mime->display();
    if( $mime->size < 10000 && ( $mime->subtype == "gif" || $mime->subtype == "jpeg" ) ) {
      $ret .= "</td><td> &nbsp &nbsp"; 
      $ret .= "<img src=view.php3?mailbox=" . urlencode($mime->mailbox) . "&index=$mime->index&bodypart=$mime->partno&actionID=" . VIEW_ATTACH . ">";
    }
    $ret .= "</td></tr></table>";
    return $ret;
  }

?>
