<?php
/*
   File: lib/db/mysql.lib.php3
   $Author: zerodiv $
   $Revision: 1.2 $
   $Date: 1998/09/22 20:09:06 $

   IMP : Copyright 1998 Charles J. Hagenbuch chuck@osmos.ml.org

   This code is under the GNU Public License
   See the file COPYING in this directory

File Purpose:
This file contains the database support for mysql.

*/

/*
HordeMysqlDb : Defines all the interaction with the base
   horde tables.
*/

class HordeMysqlDb {
   var $user_name;
   var $password;
   var $server_name;
   var $server_port;
   var $db_name;
   var $db_connect_string;
   var $db_connection_handle;
   var $persistent_mode;
   var $connection_init;

   /* The following object api MUST be within all database objects */
   var $User;
   var $Grant;
   var $ImapServer;

   Function HordeMysqlDb() {

      $this->user_name              = '';
      $this->password               = '';
      $this->server_name            = 'localhost';
      $this->server_port            = '';
      $this->db_name                = '';
      $this->db_connect_string      = '';
      $this->db_connection_handle   = undef;
      $this->persistent_mode        = true;
      $this->connection_init        = false;

      /* The following object api MUST be within all database objects */
      $this->User                   = new HordeMysqlDb_User;

      }

   Function BuildConnectString() {

      $this->db_connect_string = $this->server_name;

      if ( $this->server_port != '' ) {
         $this->db_connect_string .= ':' . $this->port_name;
         }

      }

   Function CreateConnection() {

      $this->BuildConnectString();

      if (
         $this->persistent_mode == true &&
         $this->connection_init == false ) {

         /* Open the connection to the database */
         if ( !( $this->db_connection_handle = mysql_pconnect( $this->db_connect_string, $user_name, $password ) ) {
            return $false;
            }

         /* Switch to the horde database for that connection */
         if ( !( $db_test = mysql_select_db( $this->db_connection_handle, $this->db_name ) ) { 
            return $false;
            }

         return $this->db_connection_handle;

         }

      if ( 
         $this->persistent_mode == true &&
         $this->connection_init == true ) {
         return $this->db_connection_handle;
         } 

      } /* END CreateConnection() */

      
   } /* END HordeMysqlDb class */

class HordeMysqlDb_User {
   var $connection_handle;

   /*
   Function       : HordeMysqlDbUser
   Parameters     : NONE
   Return Values  : NONE
   Purpose        : To instanciate a instance of the HordeMysqlDb object.
   */
   Function HordeMysqlDb_User() {
      $this->connection_handle = undef;
      }

   /*
   Function       : Verify
   Parameters     : (HordeUser)
   Return Values  :                    
      TRUE                             
      FALSE, Error Id
   Purpose        : To verify a users access to the horde system.
   */
   Function Verify( $ThisUser ) {
      }

   /*
   Function       : Get
   Parameters     : (HordeUser)
   Return Values  :                       
      (HordeUser) $ThisUser               
      FALSE, ERROR_ID
   Purpose        : Finds a user with the attributes that are passed in.
   */
   Function Get( $ThisUser ) {
      }

   /*
   Function       : Add
   Parameters     : (HordeUser)
   Return Values  :                       
      TRUE                                
      FALSE, ERROR_ID
   Purpose        : Adds a user with the attributes defined in the
                    $ThisUser that is passed in.
   */
   Function Add( $ThisUser ) {
      }

   /*
   Function       : Modify
   Parameters     : (HordeUser->user_id), (HordeUser) 
   Return Values  :                       
      TRUE                                
      FALSE, ERROR_ID
   Purpose        : Modify the user_id(x)'s member data to contain
                    the new data provided within the
                    passed in object
   */
   Function Modify( $user_id, $ThisUser ) {
      }

   /*
   Function       : Delete
   Parameters     : (HordeUser->user_id)
   Return Values  :
      TRUE
      FALSE, ERROR_ID
   Purpose        : To delete a user_id(x)'s data from the database.
   */
   Function Delete( $user_id ) {
      /* Delete's the specified user with that id */
      }

   /*
   Function       : List
   Parameters     : NONE
   Return Values  : Array of HordeUser objects
   Purpose        : To list all of the users within the system.
   */
   Function List() {
      /* returns an array of users */
      }
   }

?>
