<?php

/*
  
  File: config/defaults.php3
  $Author: zerodiv $
  $Revision: 1.27 $
  $Date: 1998/09/22 21:40:12 $
  
  IMP : Copywrite 1998 Charles J. Hagenbuch chuck@osmos.ml.org
  
  This code is under the GNU Public License
  See the file COPYING in this directory
  
*/


/* Imp Defaults Configuration File

This file is for configuring imp defaults.

The file itself is built around modifying the $default object
that contains sub objects for documents and user flags, options
and other items.

Several configurations are included but are commented out with
block comments like this block of text.
*/

/* Html Configuration

To configure the html for any of the documents you will need
to place values in the ImpDocument class for it.

ImpDocument Class :

class ImpDocument {
   - Html Configuration Elements - 
   var $bg_file;                    - url to a background image -
   var $bg_color;                   - background color -
   var $text_color;                 - text color -
   var $link_color;                 - link color -
   var $vlink_color;                - vlink color -
   var $alink_color;                - alink color -
   - Rest of class is ommited for clarity see
   lib/imp.lib.php3 to see all of it -

Sample:
   Lets modify the main body pages background color to white :
   $default->body->bg_color = '#ffffff'; 
*/

/* set theme colors */
$default->dark_bg                   = '#002266';
$default->light_bg                  = '#e9e9e9';
$default->text_on_light             = '#000000';
$default->text_on_dark              = '#ffffff';
$default->text_bg                   = '#ffffff';
$default->item_bg                   = '#ffffcc';
$default->new_item_bg               = '#eeeeff';
$default->nav_bg                    = '#dcdcdc';

$default->body->bg_color            = $default->light_bg;
$default->body->bg_file             = '';
$default->body->text_color          = $default->text_on_light;
$default->body->link_color          = '#0000ff';
$default->body->vlink_color         = '#0000aa';
$default->body->alink_color         = '#0000ff';
$default->sidebar->bg_color         = $default->dark_bg;
$default->sidebar->text_color       = $default->text_on_dark;
$default->sidebar->link_color       = '#e0e0e0';
$default->sidebar->vlink_color      = '#dddddd';
$default->sidebar->alink_color      = '#ffffff';
$default->sidebar->logo             = 'impsmall.gif';


/* Server Specific Configuration

Since a lot of the configuration options are changing / being added
I (zero) have not written much documentation for them. I will in
the future. I provided the sample configs to show what chuck and
I use.

When changing the server specific configuration you address the
ImpDefault object directly. Here is the imp default object:

class ImpDefaults {
  - Local Configuration -
  var $local_host_name;
      - your local host name -

  - Html Configuration -
  
  - impmain frame colors -
  var $body;    
      - ImpDocument : configures the impmain frame colors - 
  
  - impmenu (sidebar) frame colors -
  var $sidebar;
      - ImpDocument : configures the impmenu frame colors -

  - URL Configuraton -
  var $graphics_url;
      - imp specfic graphics -

  var $root_url;
      - imp base url -
  
  - IMAP Configuration -
  var $server;
      - default IMAP server to connect to -
  var $folders;
      - default directory to look in for mail folders -
  
  var $secure;
      - Use SSL for cookies if it is a secure connection -
  
  - Imp Server Configuration -
  var $user_change_server;
      - set false to force use of the default server -
  var $user_change_folder;
      - set false to force use of the default folder dir -
  var $user_change_from;
      - set false to force use of the system default from address -
  
  - Imp Client Configuration -
  var $max_messages_page;
      - max number of messages to display in one page in mailbox.php3 -

  - Imp Folder Configuration -
  var $user_home_dirs;
      - possible user home directories for LOCAL users only.
*/

/* Sample Configurations */

/* -- Alpha.jccc.net Configuration -- */
$default->root_url                  = '/devel';
$default->graphics_url              = $default->root_url . '/graphics';
$default->server                    = 'alpha.jccc.net';  
$default->port                      = 143;
$default->folders                   = 'mail/';
$default->secure                    = true;
$default->user_change_server        = false;
$default->user_change_folder        = false;
$default->user_change_from          = false;
$default->user_use_filemgr          = false;
$default->user_use_addressbook      = false;
$default->error_level               = 1;    
$default->path_to_sendmail          = '/usr/sbin/sendmail';
$default->path_to_ispell            = '/usr/bin/ispell';
$default->db_lib                    = 'lib/mysql.lib.php3';
$default->include_dir               = './templates';
$default->local_host_name           = 'alpha.jccc.net';
$default->user_home_dirs            = Array( "/home", "/homec" );
$default->ssl->snoop_dn             = false;
$default->ssl->client_auth_required = false;
$default->log->enabled              = false;
$default->cyrus                     = false;

/* -- Osmos.ml.org Configuration --
$default->root_url                  = '/cvs/imp';
$default->graphics_url              = $default->root_url . '/graphics';
$default->server                    = 'wso.williams.edu';
$default->port                      = 143;
$default->folders                   = 'mail/';
$default->secure                    = true;
$default->user_change_server        = true;
$default->user_change_folder        = true;
$default->user_change_from          = true;
$default->user_use_filemgr          = false;
$default->user_use_addressbook      = true;
$default->error_level               = 1;
$default->path_to_sendmail          = '/usr/sbin/sendmail';
$default->path_to_ispell            = '/usr/bin/ispell';
$default->db_lib                    = 'lib/mysql.lib.php3';
$default->include_dir               = './templates';
$default->local_host_name           = 'osmos.ml.org';
$default->user_home_dirs            = Array( '/home' );
$default->ssl->snoop_dn             = false;
$default->ssl->client_auth_required = false;
$default->log->enabled              = false;
$default->cyrus                     = false;
*/

/* -- valkyrie.blackcat.ca Configuration -- *
 *  Support for SSL certs and Cyrus imapd   *
 * ---------------------------------------- *
$default->root_url                  = '/imp-cvs';
$default->graphics_url              = $default->root_url . '/graphics';
$default->server                    = 'staff.gt.ca';
$default->port                      = 143;
$default->folders                   = '';
$default->secure                    = true;
$default->user_change_server        = false;
$default->user_change_folder        = false;
$default->user_change_from          = false;
$default->user_use_filemgr          = true;
$default->user_use_addressbook      = true;
$default->error_level               = 1;    
$default->path_to_imap              = '';
$default->path_to_sendmail          = '/usr/sbin/sendmail';
$default->db_lib                    = 'lib/mysql.lib.php3';
$default->include_dir               = './templates';
$default->local_host_name           = 'valkyrie.blackcat.ca';
$default->user_home_dirs            = Array( "/home", "/homec" );
$default->ssl->snoop_dn             = true;
$default->ssl->client_auth_required = true;
$default->ssl->issuers              = array("/C=CA/ST=BC/L=Vancouver/O=GT Group Telecom Inc./OU=Ecommerce/CN=admin valkyrie 01/Email=webmaster@blackcat.ca"=>true);
$default->log->enabled              = true;
$default->cyrus                     = true;
*/

?>
