<?php

/*
   
   File: login.php3
   $Author: chuck $
   $Revision: 1.17 $
   $Date: 1998/09/17 17:22:52 $
   
   IMP: Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
   
   This code is under the GNU Public License
   See the file COPYING in this directory
   
*/
  
  require( './lib/imp.lib.php3' );      /* IMPlib is the IMP function library  */
  require( './config/defaults.php3' );  /* Defaults configuration file */
  
  error_reporting($default->error_level);  /* set error level from imp.lib.php3   */
  
  /* invalidate any previous cookies */
  setcookie('chuckmIMPuser');
  setcookie('chuckmIMPpass');
  setcookie('chuckmIMPsrvr');
  setcookie('chuckmIMPfldr');
  
  if (!isset($reason)) { $reason = 'login'; }
  
  $messages[ 'login' ]     = '';
  $messages[ 'timeout' ]   = 'Either you have logged in incorrectly, or your login to IMP has expired. Please log
                              in again.';
  $messages[ 'logout' ]    = 'You have been logged out of IMP. Thank you for using the system. If you wish
                              to log in again, please use the form below.';
  $messages[ 'nocert' ]    = 'You need a valid certificate in order to access this site.';
  $messages[ 'noaccount' ] = 'You do not yet have an email account with us.';

  if( $ssl->process() && $default->ssl->check_cert != false ) {
    $ssl->snoop_dn(); 
    $ssl->verify_cert();

    if( $ssl->valid_cert_found ) {

      $CNr = split("/",$ssl->client_dn);
      for($i=0; $i<@count($CNr); $i++) {
        $CNw = split("=",$CNr[$i]);
        if( $CNw[0] == "CN" ) {
          $CN = $CNw[1];
          break;
        }
      }
      status( 'Welcome to Imp, '.$CN);
    } else {
    
      if( $default->ssl->client_auth_required )
        $reason = 'nocert';
    }
    
    if( !$valid_auth_found ) {
      if( $default->cyrus->auto_create && $default->cyrus->enabled ) {
        include( './lib/cyrus_auto_create.php3' );
        $reason = 'noaccount';
      } else {
        $reason = 'noaccount';
      }
    }
    
    include( "$default->include_dir/login.php3-ssl_login.inc" );
    
  } else {
  
    status( 'Welcome to Imp. Please log in...' );
    include( "$default->include_dir/login.php3-login.inc" );

  }

?>
