<?php

/*
   
   File: view.php3
   $Author: chuck $
   $Revision: 1.8 $
   $Date: 1998/09/13 04:23:21 $
   
   IMP: Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
   
   This code is under the GNU Public License
   See the file COPYING in this directory
   
*/
  
  require( './lib/imp.lib.php3' );      /* IMPlib is the IMP function library  */
  require( './config/defaults.php3' );  /* Defaults configuration file */
  
  error_reporting($default->error_level);  /* set error level from imp.lib.php3   */
  header('Expires: 120');         /* make the page expire in 2 minutes   */
  
  $user    = getuser();
  $pass    = getpass();
  $folders = getfldr();
  $server  = getsrvr();
  if (!$mailbox) { $mailbox = "INBOX"; }
  
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  
  $structure = imap_fetchstructure ($mbox,$index);
  $parts = $structure->parts[$bodypart];
  $encoding = $parts->encoding;
  $parameters = $parts->dparametres;
  $filename = $parameters[0]->value;
  $subtype = $parts->subtype;
  
  $bodypart++;
  
  /* Run through action handlers */
  if (isset($action)) {
    switch($action) {
      case NO_ACTION:
        break;
      
      case DOWNLOAD_ATTACH:
        if (($subtype == 'JPEG') || ($subtype == 'GIF')) {
	  header("Content-type: $subtype");
	} else {
	  header("Content-type: application/$subtype");
	}
	break;
      
      case VIEW_ATTACH:
        if (($subtype == 'JPEG') || ($subtype == 'GIF')) {
	  header("Content-type: IMAGE/$subtype");
	} else {
	  header("Content-type: text/$subtype");
	}
	break;
      
    }
  }
  
  header("Content-Disposition: inline; filename=$filename");
  $body = imap_fetchbody ($mbox, $index, $bodypart);
  
  if ($encoding == 3) { echo imap_base64($body); }
  else { echo $body; }
  
  imap_close($mbox);
?>
