<?php

/*
   
   File : lib/imp.lib.php3
   $Author: chuck $
   $Revision: 1.54 $
   $Date: 1998/09/13 23:38:50 $
   
   IMP : Copyright 1998 Charles J. Hagenbuch chuck@osmos.ml.org
   
   This code is under the GNU Public License
   See the file COPYING in this directory

*/

/* Bring in the horde libary for the base and other classes needed */
require( "./lib/horde.lib.php3" );

/* Define the IMP version */
$temp_ver = '$Revision: 1.54 $';

$temp_ver = ereg_replace( 'Revision: ', '', $temp_ver );
$temp_ver = ereg_replace( '\$', '', $temp_ver );

define("IMP_VERSION",  $temp_ver );

/* Define all of the actions */

define("NO_ACTION",         0);
define("DELETE_MESSAGES",   1);
define("UNDELETE_MESSAGES", 2);
define("MOVE_MESSAGES",     3);
define("COPY_MESSAGES",     4);
define("EXPUNGE_MAILBOX",   5);
define("IMP_LOGIN",         6);
define("REPLY",             7);
define("REPLY_ALL",         8);
define("FORWARD",           9);
define("DELETE_FOLDER",    10);
define("CREATE_FOLDER",    11);
define("RENAME_FOLDER",    12);
define("DOWNLOAD_ATTACH",  13);
define("VIEW_ATTACH",      14);
define("DELETE_ADDR",      15);
define("ADD_ADDR",         16);
define("UPDATE_ADDR",      17);
define("UPDATE_SIGNATURE", 18);
define("SEND_MESSAGE",     19);
define("POSTPONE_MESSAGE", 20);
/* MENU Modes */
define("IMPMENU_DORMANT",  100 );
define("IMPMENU_MAIN",     200 );
define("IMPMENU_BLANK",    999 );
/* IMP CONFIGURATOR MODES */
define("IMPCFGMGR_WRITE_CONFIG", 800 );


/* Define the logging events */
define("SENT",			51);
define("DELETED",		52);
define("SENT_SIGNED",		53);
define("RECEIVED",		54);
define("RECEIVED_SIGNED",	55);

/* Classes */



/*
  Deprecated Variables:
  
  Old Variable:          New Variable:
  
  $imp_graphics       -> $default->graphics_url
  $imp_root           -> $default->root_url
  $default_server     -> $default->server
  $default_folders    -> $default->folders
  $default_secure     -> $default->secure
  $user_change_server -> $default->user_change_server
  $user_change_folder -> $default->user_change_folder
  $max_messages_page  -> $default->max_messages_page
  $error_level        -> $default->error_level
  $path_to_db_lib     -> $default->db_lib
  
*/


/* Initialization */

$default = new ImpDefaults();              /* Create and initialize Defaults Object */

/* Functions */

/* function to wrap text at $wrap, semi-gracefully */

function fill_paragraphs($text, $wrap=80, $break="\n", $delim='+') {
  $lines = explode("\n", $text);
  
  $i = 0;
  
  while ($i < sizeof ($lines)) {
    if (strlen($lines[$i]) < $wrap) {
      $result[count($result)] = $lines[$i];
      $i++;
    } else {
      $result[count($result)] = substr($lines[$i], 0, $wrap);
      $lines[$i] = $delim . substr($lines[$i], $wrap, strlen($lines[$i]) - $wrap);
    }
  }
  return implode($break, $result);
}


/* function to decode a MIME-encoded string, returns the original string, if not MIME */

function decode_mime_string ($string) {
if ( eregi( "\=\?([A-Z,0-9,-]+)\?([A-Z,0-9,-]+)\?([A-Z,0-9,-,=,_]+)\?\=",  $string)) {
    $coded_strings = split("=\?", $string);
    $counter = 1;
    $string = '';
  while ($counter < sizeof($coded_strings)) {
    $elements = split ("\?", $coded_strings[$counter]);
    if ( eregi("Q", $elements[1] ) ) {
      $elements[2] = eregi_replace("=([A-F,0-9]{2})", "%\\1", $elements[2]);
      $string .= urldecode($elements[2]);
      } else {
      $elements[2] = ereg_replace("=", "", $elements[2]); 
      if ($elements[2]) { $string .= base64_decode($elements[2]); }
      }
    $counter++;
    }
  $string = ereg_replace("_", " ", $string);
  }
  return $string;
}


/* obtain the -0400 or whatever it is for you offset for the date header */

function gm_offset() {
  $offset = ((date("H") - gmdate("H")));
  if ($offset >= 0) { return sprintf("+%02d", $offset) . "00"; }
  else { return sprintf("-%02d", -$offset) . "00"; }
}


/* obtain a (possibly filtered) list of mailboxes */

function mailbox_list ($filter = '', $header = false) {
  global $mbox, $server, $folders, $mailbox, $default, $user;
  
  if ($default->cyrus) {
    $mboxes_f = imap_listmailbox($mbox, "{$server}", "user.$user.*");
    /*
     *  Clean all the cyrus cruft from the start of the mailbox names.
     *
     *  FIXME!!  This will miss subscribed boxes that are outside of the user's namespace (ex: group boxes)
     */
    for( $i=0; $i<@count($mboxes_f); $i++ ) {
      $mboxes[] = ereg_replace("{$server}user\.$user\.","",$mboxes_f[$i]);
    }
  } else {
    $mboxes = imap_listmailbox($mbox, "{$server}", "$folders/*");
  }
  sort($mboxes);
  
  $options = '';
  if ($header) { $options .= '<option value="">selected mail to:</option>'; }
  if ($filter != 'INBOX' && $mailbox != 'INBOX') { $options .= '<option value="INBOX">Inbox</option>'; }
  
  for ($i = 0; $i < count($mboxes); $i++) {
    $label = eregi_replace("{$server}$folders/+", '', $mboxes[$i]);
    $value = "$folders/$label";
    if ($filter != $value) { $options .= "    <option value=\"$value\">$label</option>\n"; }
  }
  
  return $options;
}

/* SSL certificate processing. */
class SSLstate {
  var $valid_cert_found;
  var $valid_auth_found;
  var $verified;
  var $ssl_user;
  var $ssl_pass;
  var $client_dn;

  Function SSLstate() {
    $this->valid_cert_found = false;
    $this->valid_auth_found = false;
    $this->verfied = false;
    $this->ssl_user = "";
    $this->ssl_pass = "";
    $this->client_dn = "";
  }

  function snoop_dn() {
    global $default;
    if( $default->ssl->snoop_dn ) {
      echo "<pre><b>Client DN:</b> \"".$GLOBALS["SSL_CLIENT_DN"]."\"<br><b>Issuer DN:</b> \"".$GLOBALS["SSL_ISSUER_DN"]."\"<br>\n</pre>";
    }
  }

  function verify_cert() {
    global $SSL_CLIENT_DN, $SSL_ISSUER_DN, $default;
    if( $this->verified ) { return $this->valid_auth_found; }

    $this->verfied = true;
    $this->client_dn = $SSL_CLIENT_DN;

    if( $default->ssl->client_auth_required ) {
      if( empty($SSL_CLIENT_DN) || empty($SSL_ISSUER_DN) ) {
        status("Invalid Cert.");
        $this->valid_cert_found = false;
        return false;
      }
      if( $default->ssl->issuers[$SSL_ISSUER_DN] != true ) {
        status("Invalid Issuer");
        $this->valid_cert_found = false;
        return false;
      }
    }
    $this->valid_cert_found = true;

  /*   FIXME!!  The database routines need to be
   *   moved to mysql.lib.php3 and made generic.
   */

    if( !($db = mysql_pconnect("localhost","www-data")) ) {
      status("Error in SSL->IMAP __FILE__(__LINE__): DB not found."); 
      return false;
    }
    if( !($dbs = mysql_select_db("imp",$db)) ) {
      status("Error in SSL->IMAP __FILE__(__LINE__): Can't select DB."); 
      return false;
    }
    $res = mysql_db_query("imp","select * from ssl_to_imp where DN = '".$GLOBALS["SSL_CLIENT_DN"]."'",$db);
    if( mysql_num_rows($res) > 0 ) {
      $arr = mysql_fetch_array($res);
      $this->ssl_user = $arr["username"];
      $this->ssl_pass = $arr["password"];
      $this->valid_auth_found = true;
    } else {
      status("No auth found in database");
      $this->valid_auth_found = false;
    }
    mysql_free_result($res);  
    return $this->valid_auth_found;
  }

  function process() {
    global $default;
    if( $default->ssl->client_auth_required || $default->ssl->issuers || $default->ssl->check_cert ) { return true; }
    return false;
  }

}

$ssl = new SSLstate;


/* make sure the user has a valid login; if so, return an imap stream */

function validate_login($server, $mailbox, $user, $pass) {
  if (! ($mbox = imap_open("{$server:143}$mailbox", $user, $pass)) ) {
    echo '<script language=javascript>
          if ( this != parent.impfolder )
	  document.location="login.php3?reason=timeout";
	  </script>
	  ';
  }
  return $mbox;
}


/* function that interfaces to sendmail, so from address and all headers
 * are set correctly
 */

function mailfrom($user, $server, $to, $from, $subject, $hdrs, $message) {
  global $default;
  
  $mail = popen("$default->path_to_sendmail -t -f '$user@$server'", 'w');
  
  $result  = fputs($mail, "To: $to\n");
  $result += fputs($mail, "From: $from\n");
  $result += fputs($mail, $hdrs);
  $result += fputs($mail, "Subject: $subject\n\n");
  $result += fputs($mail, $message);
  
  pclose($mail);
  
  if ($result > 0) { return 1; }
  else { return 0; }
}


/* cookie setting functions
 * 
 * the strtr in the cookie setting functions is NOT encryption. SSL is
 * relied on for the encryption - if you don't use SSL, NONE of this is
 * secure. this is just in case cookie values get displayed on the screen,
 * or something similar. If someone has a better way, please let me know.
 */

$trans_fwd = ' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+=-';
$trans_bck = '1234567890-=ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+abcdefghijklm nopqrstuvwxyz';

function setuser($user) {
  global $default, $SERVER_PORT, $trans_fwd, $trans_bck, $ssl;
  
  if ($SERVER_PORT == 443 && $default->secure) { $secure = 1; }
  else { $secure = 0; }

  if ($ssl->process()) {
    $ssl->verify_cert();
    $user = $ssl->ssl_user;
  } else {
    setcookie('chuckmIMPuser', strtr($user, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
  }
}

function setpass($pass) {
  global $default, $SERVER_PORT, $trans_fwd, $trans_bck, $ssl;
  
  if ($SERVER_PORT == 443 && $default->secure) { $secure = 1; }
  else { $secure = 0; }
  
  if ($ssl->process()) {
    $ssl->verify_cert();
    $pass = $ssl->ssl_pass;
  } else {
    setcookie('chuckmIMPpass', strtr($pass, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
  }
}

function setsrvr($srvr) {
  global $default, $SERVER_PORT, $trans_fwd, $trans_bck;
  
  if ($SERVER_PORT == 443 && $default->secure) { $secure = 1; }
  else { $secure = 0; }
  
  if ($srvr != '') {
    setcookie('chuckmIMPsrvr', strtr($srvr, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
    return $srvr;
  } else {
    setcookie('chuckmIMPsrvr', strtr( $default->server, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
    return $default->server;
  }
}

function setfldr($fldr) {
  global $default, $SERVER_PORT, $trans_fwd, $trans_bck;
  
  if ($SERVER_PORT == 443 && $default->secure) { $secure = 1; }
  else { $secure = 0; }
  
  if ($fldr != '') {
    setcookie('chuckmIMPfldr', strtr($fldr, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
    return $fldr;
  } else {
    setcookie('chuckmIMPfldr', strtr($default->folders, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
    return $default->folders;
  }
}


/* cookie retrieval functions */

function getuser() {
  global $chuckmIMPuser, $trans_fwd, $trans_bck, $ssl;

  if ($ssl->process()) {
    $ssl->verify_cert();
    return $ssl->ssl_user;
  }
  return strtr($chuckmIMPuser, $trans_bck, $trans_fwd);
}

function getpass() {
  global $chuckmIMPpass, $trans_fwd, $trans_bck, $ssl;
  
  if ($ssl->process()) {
    $ssl->verify_cert();
    return $ssl->ssl_pass;
  }
  return strtr($chuckmIMPpass, $trans_bck, $trans_fwd);
}

function getsrvr() {
  global $default, $chuckmIMPsrvr, $trans_fwd, $trans_bck;
  
  if (isset($chuckmIMPsrvr)) {
    return strtr($chuckmIMPsrvr, $trans_bck, $trans_fwd);
  } else {
    return $default->server;
  }
}

function getfldr() {
  global $default, $chuckmIMPfldr, $trans_fwd, $trans_bck;
  
  if (isset($chuckmIMPfldr)) {
    return strtr($chuckmIMPfldr, $trans_bck, $trans_fwd);
  } else {
    return $default->folders;
  }
}


function status($message, $status='green') {
  global $status_sent;
  
  echo '<script language="JavaScript">';
  echo 'if (parent.impstatus) {';
  echo 'parent.impstatus.location="status.php3?message=' . urlencode($message) . "&status=$status" . '";';
  echo '}';
  echo '</script>';
  
  $status_sent = true;
}

function log_event( $user, $target, $event, $log, $md5 ) {
  global $default;
  if( ! $default->log->enabled ) { return true; }

  /*   FIXME!!  The database routines need to be
   *   moved to mysql.lib.php3 and made generic.
   */

  if( !($db = mysql_pconnect("localhost","www-data")) ) {
    status("Error in LOG __FILE__(__LINE__): DB not found."); 
    return false;
  }
  if( !($dbs = mysql_select_db("imp",$db)) ) {
    status("Error in LOG __FILE__(__LINE__): Can't select DB."); 
    return false;
  }
  $res = mysql_db_query("imp","insert into imp_log values ('$user',now(),$event,'$target','$log','$md5')",$db);
  if( !$res ) {
    status( "error committing log information");
  }
  mysql_free_result($res);  
}


/* end imp.lib */

?>
