<?php

/*
   
   File : lib/horde.lib.php3
   $Author: paudley $
   $Revision: 1.6 $
   $Date: 1998/09/13 22:07:44 $
   
   IMP : Copyright 1998 Charles J. Hagenbuch chuck@osmos.ml.org
   
   This code is under the GNU Public License
   See the file COPYING in this directory

File Purpose:
This file contains the base classes and their descendents for 
the interoperability of the horde. 

*/

/* ------------------------------------------------------------ */

/* Experimental / Votile classes :
DO NOT DEPEND ON THESE NOT CHANGING
*/

/*
Defines for types of imap servers.
*/
/* MS_EXCHANGE_IMAP : Ms Exchange imap service. */
define( "MS_EXCHANGE_IMAP", 		1001 );
/* CYRUS_IMAP       : The cyrus imap server. */
define( "CYRUS_IMAP", 				2001 );
/* UNKNOWN_IMAP     : Otherwise known as RFC 822. */
define( "UKNOWN_IMAP",				9999 );

class HordeGrant
	{

	var $read;
	var $write;
	var $modify;
	var $with_grant_option;

	Function HordeGrant()
		{
		$this->read 					= false;
		$this->write 					= false;
		$this->modify					= false;
		$this->public					= false;
		$this->with_grant_option	= false;
		}
	}

/* ------------------------------------------------------------ */



/* ------------------------------------------------------------ */
/*
BASE Classes :

Classes that are common to all or some of the horde.

*/
class HtmlDocument {
   
   /* Html Configuration Elements */
   var $bg_file;                    /* url to a background image */
   var $bg_color;                   /* background color */
   var $text_color;                 /* text color */
   var $link_color;                 /* link color */
   var $vlink_color;                /* vlink color */
   var $alink_color;                /* alink color */
   
   function generate_body() {
      echo( '<body' );
      if ( $this->bg_file != '')    { echo( ' background="'     . $this->bg_file . '"'  ); }
      if ( $this->bg_color )        { echo( ' bgcolor="'        . $this->bg_color . '"' ); }
      if ( $this->text_color )      { echo( ' text="'           . $this->text_color . '"' ); }
      if ( $this->link_color )      { echo( ' link="'           . $this->link_color . '"' ); }
      if ( $this->vlink_color )     { echo( ' vlink="'          . $this->vlink_color . '"' ); }
      if ( $this->alink_color )     { echo( ' alink="'          . $this->alink_color . '"' ); }
      echo( ">\n" );
   } /* END function generate_body() */
   
}
/* -- END Base Classes -- */
/* ------------------------------------------------------------ */

/* ------------------------------------------------------------ */
/*

IMP Objects :

The configuration objects / objects that the IMP module shares to
the horde.

*/
class ImpDefaults {
  
  /* Html Configuration */
  
  /* Colors organized by general element. Hopefully, one should be able
     to set these, and have IMP follow them to create a whole new color scheme */
  
  var $dark_bg;
  var $light_bg;
  var $text_bg;
  var $item_bg;
  var $nav_bg;
  
  /* impmain frame colors */
  var $body;                            /* HtmlDocument : configures the impmain frame colors */
  
  /* impmenu (sidebar) frame colors */
  var $sidebar;                         /* HtmlDocument : configures the impmenu frame colors */
  
  /* URL Configuraton */
  var $graphics_url;                    /* imp specfic graphics */
  var $root_url;                        /* imp base url */
  
  /* Files Configuration */
  var $include_dir;                     /* the directory all of the includes live in */
  
  /* IMAP Configuration */
  var $server;                    /* default IMAP server to connect to */
  var $folders;                        /* default directory to look in for mail folders     */
  
  var $secure;               /* Use SSL for cookies if it is a secure connection  */

  /* Is your imap server Cyrus? */
  var $cyrus;
  
  /* Imp Server Configuration */
  var $user_change_server;          /* set false to force use of the default server      */
  var $user_change_folder;          /* set false to force use of the default folder dir  */
  var $user_use_filemgr;            /* Ftp file management system */
  var $user_use_addressbook;        /* Address book on / off flag */
 
  /* Imp Client Configuration */
  var $max_messages_page;     /* max number of messages to display in one page in mailbox.php3  */
  
  /* Imp Debugging Configuration */
  var $error_level = 1;                 /* level of error_reporting()  */

  /* Local Server Authentication */
  var $local_host_name;

  /* Imp Folder Configuration */
  /*    - Controls the file management module. */
  var $user_home_dirs;

  /* SSL Certificate Configuration */
  var $ssl;

  /* Logging Configuration */
  var $log;

  /* Constructor */
  Function ImpDefaults() {
    $this->body     = new HtmlDocument;
    $this->sidebar  = new HtmlDocument;
    $this->ssl      = new SSLDefaults;
    $this->log      = new LogDefaults;
    
    $this->max_messages_page = 50;
    $this->root_url          = '';
    $this->cyrus             = false;
    $this->graphics_url      = $this->root_url . '/graphics';
    $this->user_home_dirs    = Array();

  }
  
}

/* USER Defaults */

class ImpUserDefaults {
  /* Html Configuration */
  var $body;                       /* HtmlDocument : body frame configuration */
  
  /* Imp Client Configuration */
  var $max_messages_page;          /* max number of messages to display in one page in mailbox.php3  */
  
  Function ImpUserDefaults() {
     $this->body = new HtmlDocument;
  }
  
}

class SSLDefaults {
  
  /* SSL Certificate Configuration */
  
  /* set to true to enable ssl cert checking */

  var $check_cert;

  /* If this is set to true, only allow access to people who present
     a client cert that is issued by someone in the list of issuers. */

  var $client_auth_required;

  /*  A array of DNs from issuers that we recognize.
  
     Ex:
	$issuers = array(
          "/C=CA/ST=BC/L=Vancouver/O=GT Group Telecom Inc./OU=Ecommerce/CN=admin valkyrie 01/Email=webmaster@blackcat.ca"=>true
	);
  
    As these are generally tricky to get from netscape, if you set 
     $snoop_dn = true; both DNs are displayed.                       */

  var $issuers;
  var $snoop_dn;

  Function SSLDefaults() {
    $this->client_auth_required = false;
    $this->check_cert = false;
    $this->snoop_dn = false;    
  }
}

class LogDefaults {

  /* Logging Configuration */
  
  var $enabled;

  Function LogDefaults() {
    $this->enabled = false;
  }
}


/* -- END IMP Objects -- */
/* ------------------------------------------------------------ */
?>
