<?php

/*
   
   File: mailbox.php3
   $Author: chuck $
   $Revision: 1.24 $
   $Date: 1998/08/26 20:32:24 $
   
   IMP : Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
   
   This code is under the GNU Public License
   See the file COPYING in this directory

*/
  
  require( './lib/imp.lib.php3' );      /* IMPlib is the IMP function library */
  require( './config/defaults.php3' );  /* Defaults configuration file */
  
  error_reporting($default->error_level);  /* set error level from imp.lib.php3   */
  
  /* Set or read cookies */
  if ($action != IMP_LOGIN) {
    $user    = getuser();
    $pass    = getpass();
    $folders = getfldr();
    $server  = getsrvr();
  } else {
    setuser($user);
    setpass($pass);
    $server  = setsrvr($server);
    $folders = setfldr($folders);
  }
  
  
  if (!isset($mailbox)) { $mailbox = 'INBOX'; }
  if (!isset($start)) { $start = 1; }
  $current_mbox = eregi_replace("{$server}$folders/*", '', $mailbox);
 
   
  header('Expires: 120');         /* make the page expire in 2 minutes   */

  /* only proceed on a valid login */
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  
  /* Run through the action handlers */
  
  if (isset($action)) {
    
    if (substr($indices, -0, 1) == ',') {
      $indices = substr($indices, 0, strlen($indices) - 1);
    }
    
    switch ($action) {
      case NO_ACTION:
        status( "Mailbox: $current_mbox" );
        break;
      
      case DELETE_MESSAGES:
        if ($indices && $mailbox) {
	  $indices = split(',', $indices);
	  for ($i = 0; $i < count($indices); $i++) {
	    if (!(imap_delete($mbox, $indices[$i]))) {
	      status( "Mailbox: $current_mbox: Error: Message Deletion Failed", 'red' );
	    }
	  }
	  if (!$status_sent) {
	    $i--;
	    if ($i != 1) { $punct = 's'; }
	    status( "Mailbox: $current_mbox: Deleted $i Message$punct" );
	  }
	}
        if (!$status_sent) { status( "Mailbox: $current_mbox: Error: Message Deletion Failed" , 'red'); }
	break;
      
      case UNDELETE_MESSAGES:
        if ($mailbox && $indices) {
	  $indices = split(',', $indices);
	  for ($i = 0; $i < count($indices); $i++) {
	    if (!(imap_undelete($mbox, $indices[$i]))) {
              status( "Mailbox: $current_mbox: Error: Message Undeletion Failed" , 'red');
	    }
	  }
	  if (!$status_sent) {
	    $i--;
	    if ($i != 1) { $punct = 's'; }
	    status( "Mailbox: $current_mbox: Undeleted $i Message$punct" );
	  }
	}
        if (!$status_sent) { status( "Mailbox: $current_mbox: Error: Message Undeletion Failed", 'red' ); }
	break;
      
      case MOVE_MESSAGES:
        if ($target && $indices) {
	  if (! (imap_mail_move($mbox, $indices, $target)) ) {
	    status( "Mailbox: $current_mbox: Error: Message Move Failed", 'red' );
	  } else {
	    if ( (count(split(',', $indices)) - 1) != 1) { $punct = 's'; }
	    status( "Mailbox: $current_mbox: Moved " . (count(split(',', $indices)) - 1) . " Message$punct  to $target" );
	  }
	}
        if (!$status_sent) { status( "Mailbox: $current_mbox: Error: Message Move Failed", 'red' ); }
	break;
      
      case COPY_MESSAGES:
        if ($target && $indices) {
	  if (!(imap_mail_copy($mbox, $indices, $target)) ) {
            status( "Mailbox: $current_mbox: Error: Message Copy Failed", 'red' );
	  } else {
	    if ( (count(split(',', $indices)) - 1) != 1) { $punct = 's'; }
	    status( "Mailbox: $current_mbox: Copied " . (count(split(',', $indices)) - 1) . " Message$punct to $target" );
	  }
	}
        if (!$status_sent) { status( "Mailbox: $current_mbox: Error: Message Copy Failed", 'red' ); }
	break;
      
      case EXPUNGE_MAILBOX:
        if ($mailbox) {
	  if (!(imap_expunge($mbox))) {
            status( "Mailbox: $current_mbox: Error: Mailbox Expunge Failed", 'red' );
	  } else {
	    status( "Mailbox: $current_mbox: Expunged Mailbox" );
	  }
	}
        if (!$status_sent) { status( "Mailbox: $current_mbox: Error: Mailbox Expunge Failed", 'red' ); }
	break;
      
      case IMP_LOGIN:
        echo '<script language="JavaScript">
	      if (parent.impmenu) {
	        parent.impmenu.location="menu.php3";
	      }
	      if (parent.impfolder) {
	        parent.impfolder.location="select.php3";
	      }
	      </script>
	';
        status( "Mailbox: $current_mbox" );
	break;
    }
  } else { status( "Mailbox: $current_mbox" ); }
  
  $title = "Index of $current_mbox";
  include( "$default->include_dir/generic-header.inc");
  
  $nummsgs = imap_num_msg($mbox);
  
  if ($nummsgs < $default->max_messages_page) { $start = 1; }
  elseif ($nummsgs - $start < $default->max_messages_page) { $start = $nummsgs - $default->max_messages_page; }
  
  if ($nummsgs < $start + $default->max_messages_page) { $end = $nummsgs; }
  else { $end = $start + $default->max_messages_page; }
  
  /* figure out whether to include the prev/next page links or not, and if so,
   * what to index them at. */
  
  if ($nummsgs > $default->max_messages_page) {
    if ($start > 1) {
      if ($start - $default->max_messages_page >= 1) { $prevstart = $start - $default->max_messages_page; }
      else { $prevstart = 1; }
      $mailbox_navigation .= "<a href=\"mailbox.php3?mailbox=$mailbox&start=$prevstart\">previous page</a> ";
    }
    if ($start + $default->max_messages_page < $nummsgs) {
      $nextstart = $start + $default->max_messages_page;
      $mailbox_navigation .= "<a href=\"mailbox.php3?mailbox=$mailbox&start=$nextstart\">next page</a> ";
    }
  }
  
  $check=imap_check($mbox);
  include( "$default->include_dir/mailbox.php3-header.inc");
  
  $options = mailbox_list($mailbox, true);
  
  $form_num = 1;
  include( "$default->include_dir/mailbox.php3-navbar.inc");
  include( "$default->include_dir/mailbox.php3-actions.inc");
  include( "$default->include_dir/mailbox.php3-message_headers.inc");
  
  for ($i=$start; $i <= $end; $i++) {
    if (! imap_ping($mbox) ) {
      $mbox = imap_open("{$server}$mailbox",$user,$pass);
    }
    
    $h=imap_header($mbox,$i);
    
    $dat = chop(substr(htmlentities($h->date), 0, 11));
    $frm = chop(htmlentities($h->fromaddress));
    $sub = chop(htmlentities($h->subject));
    
    if ($dat == '') { $dat = '&nbsp;'; }
    if ($frm == '') { $frm = '&nbsp;'; }
    if ($sub == '') { $sub = '[no subject]'; }
    
    include( "$default->include_dir/mailbox.php3-message_summaries.inc" );
  }
  
  include( "$default->include_dir/mailbox.php3-message_footers.inc" );
  include( "$default->include_dir/mailbox.php3-actions.inc" );
  
  $form_num = 2;
  include( "$default->include_dir/templates/mailbox.php3-navbar.inc" );
  include( "$default->include_dir/generic-footer.inc" );
  include( "$default->include_dir/mailbox.php3-javascript.inc" );
?>
