<?php

/*
   
   File : lib/imp.lib.php3
   $Author: chuck $
   $Revision: 1.39 $
   $Date: 1998/08/26 20:32:26 $
   
   IMP : Copyright 1998 Charles J. Hagenbuch chuck@osmos.ml.org
   
   This code is under the GNU Public License
   See the file COPYING in this directory

*/


/* Define the IMP version */
$temp_ver = '$Revision: 1.39 $';

$temp_ver = ereg_replace( 'Revision: ', '', $temp_ver );
$temp_ver = ereg_replace( '\$', '', $temp_ver );

define("IMP_VERSION",  $temp_ver );

/* Define all of the actions */

define("NO_ACTION",         0);
define("DELETE_MESSAGES",   1);
define("UNDELETE_MESSAGES", 2);
define("MOVE_MESSAGES",     3);
define("COPY_MESSAGES",     4);
define("EXPUNGE_MAILBOX",   5);
define("IMP_LOGIN",         6);
define("REPLY",             7);
define("REPLY_ALL",         8);
define("FORWARD",           9);
define("DELETE_FOLDER",    10);
define("CREATE_FOLDER",    11);
define("RENAME_FOLDER",    12);
define("DOWNLOAD_ATTACH",  13);
define("VIEW_ATTACH",      14);
define("DELETE_ADDR",      15);
define("ADD_ADDR",         16);
define("UPDATE_ADDR",      17);
define("UPDATE_SIGNATURE", 18);
define("SEND_MESSAGE",     19);
define("POSTPONE_MESSAGE", 20);


/* Classes */

class ImpDocument {
   
   /* Html Configuration Elements */
   var $bg_file;                    /* url to a background image */
   var $bg_color;                   /* background color */
   var $text_color;                 /* text color */
   var $link_color;                 /* link color */
   var $vlink_color;                /* vlink color */
   var $alink_color;                /* alink color */
   
   function generate_body() {
      echo( '<body' );
      if ( $this->bg_file != '')    { echo( ' background="' . $this->bg_file . '"'  ); }
      if ( $this->bg_color )        { echo( ' bgcolor="' . $this->bg_color . '"' ); }
      if ( $this->text_color )      { echo( ' text="' . $this->text_color . '"' ); }
      if ( $this->link_color )      { echo( ' link="' . $this->link_color . '"' ); }
      if ( $this->vlink_color )     { echo( ' vlink="' . $this->vlink_color . '"' ); }
      if ( $this->alink_color )     { echo( ' alink="' . $this->alink_color . '"' ); }
      echo( ">\n" );
   } /* END function generate_body() */
   
}

class ImpDefaults {
  
  /* Html Configuration */
  
  /* Colors organized by general element. Hopefully, one should be able
     to set these, and have IMP follow them to create a whole new color scheme */
  
  var $dark_bg;
  var $light_bg;
  var $text_bg;
  var $item_bg;
  var $nav_bg;
  
  /* impmain frame colors */
  var $body;                            /* ImpDocument : configures the impmain frame colors */
  
  /* impmenu (sidebar) frame colors */
  var $sidebar;                         /* ImpDocument : configures the impmenu frame colors */
  
  /* URL Configuraton */
  var $graphics_url;                    /* imp specfic graphics */
  var $root_url;                        /* imp base url */
  
  /* Files Configuration */
  var $include_dir;                     /* the directory all of the includes live in */
  
  /* IMAP Configuration */
  var $server;	 	                /* default IMAP server to connect to */
  var $folders;			        /* default directory to look in for mail folders     */
  
  var $secure;			        /* Use SSL for cookies if it is a secure connection  */
  
  /* Imp Server Configuration */
  var $user_change_server; 	        /* set false to force use of the default server      */
  var $user_change_folder;	        /* set false to force use of the default folder dir  */
  
  /* Imp Client Configuration */
  var $max_messages_page; 		/* max number of messages to display in one page in mailbox.php3  */
  
  /* Imp Debugging Configuration */
  var $error_level = 1;                 /* level of error_reporting()  */
  
  /* Constructor */
  Function ImpDefaults() {
    $this->body     = new ImpDocument;
    $this->sidebar  = new ImpDocument;
    
    $this->max_messages_page = 50;
    $this->root_url          = '';
    $this->graphics_url	     = $this->root_url . '/graphics';
  }
  
}


/* USER Defaults */

class ImpUserDefaults {
  /* Html Configuration */
  var $body;                       /* ImpDocument : body frame configuration */
  
  /* Imp Client Configuration */
  var $max_messages_page;          /* max number of messages to display in one page in mailbox.php3  */
  
  Function ImpUserDefaults() {
     $this->body = new ImpDocument;
  }
  
}

/*
  Deprecated Variables:
  
  Old Variable:          New Variable:
  
  $imp_graphics       -> $default->graphics_url
  $imp_root           -> $default->root_url
  $default_server     -> $default->server
  $default_folders    -> $default->folders
  $default_secure     -> $default->secure
  $user_change_server -> $default->user_change_server
  $user_change_folder -> $default->user_change_folder
  $max_messages_page  -> $default->max_messages_page
  $error_level        -> $default->error_level
  $path_to_db_lib     -> $default->db_lib
  
*/


/* Initialization */

if ($path_to_imap) { dl($path_to_imap); }  /* load the imap module if needed  */
$default = new ImpDefaults();              /* Create and initialize Defaults Object */



/* Functions */


/* function to wrap text at $wrap, semi-gracefully */

function fill_paragraphs($text, $wrap=80, $break="\n", $delim='+') {
  $lines = explode("\n", $text);
  
  $i = 0;
  
  while ($i < sizeof ($lines)) {
    if (strlen($lines[$i]) < $wrap) {
      $result[count($result)] = $lines[$i];
      $i++;
    } else {
      $result[count($result)] = substr($lines[$i], 0, $wrap);
      $lines[$i] = $delim . substr($lines[$i], $wrap, strlen($lines[$i]) - $wrap);
    }
  }
  return implode($break, $result);
}

/* function to decode a MIME-encoded string, returns the original string, if not MIME */

function decode_mime_string ($string) {
if ( eregi( "\=\?([A-Z,0-9,-]+)\?([A-Z,0-9,-]+)\?([A-Z,0-9,-,=,_]+)\?\=",  $string)) {
    $coded_strings = split("=\?", $string);
    $counter = 1;
    $string = '';
  while ($counter < sizeof($coded_strings)) {
    $elements = split ("\?", $coded_strings[$counter]);
    if ( eregi("Q", $elements[1] ) ) {
      $elements[2] = eregi_replace("=([A-F,0-9]{2})", "%\\1", $elements[2]);
      $string .= urldecode($elements[2]);
      } else {
      $elements[2] = ereg_replace("=", "", $elements[2]); 
      if ($elements[2]) { $string .= base64_decode($elements[2]); }
      }
    $counter++;
    }
  $string = ereg_replace("_", " ", $string);
  }
  return $string;
}


/* obtain the -0400 or whatever it is for you offset for the date header */

function gm_offset() {
  $offset = ((date("H") - gmdate("H")));
  if ($offset >= 0) { return sprintf("+%02d", $offset) . "00"; }
  else { return sprintf("-%02d", -$offset) . "00"; }
}


/* obtain a (possibly filtered) list of mailboxes */

function mailbox_list ($filter = '', $header = false) {
  global $mbox, $server, $folders, $mailbox;
  
  $mboxes = imap_listmailbox($mbox, "{$server}", "$folders/*");
  $options = '';
  
  if ($header) { $options .= '<option value="">selected mail to:</option>'; }
  if ($filter != 'INBOX' && $mailbox != 'INBOX') { $options .= '<option value="INBOX">Inbox</option>'; }
  
  for ($i = 0; $i < count($mboxes); $i++) {
    $label = eregi_replace("{$server}$folders/+", '', $mboxes[$i]);
    $value = "$folders/$label";
    if ($filter != $value) { $options .= "    <option value=\"$value\">$label</option>\n"; }
  }
  
  return $options;
}


/* make sure the user has a valid login; if so, return an imap stream */

function validate_login($server, $mailbox, $user, $pass) {
  if (! ($mbox = imap_open("{$server:143}$mailbox", $user, $pass)) ) {
    echo '<script language=javascript>
          if ( this != parent.impfolder )
	  document.location="login.php3?reason=timeout";
	  </script>
	  ';
  }
  return $mbox;
}


/* function that interfaces to sendmail, so from address and all headers
 * are set correctly
 */

function mailfrom($to, $from, $subject, $hdrs, $message) {
  global $default;
  
  $mail = popen("$default->path_to_sendmail -t -f '$from'", 'w');
  
  $result  = fputs($mail, "To: $to\n");
  $result += fputs($mail, "From: $from\n");
  $result += fputs($mail, $hdrs);
  $result += fputs($mail, "Subject: $subject\n\n");
  $result += fputs($mail, $message);
  
  pclose($mail);
  
  if ($result > 0) { return 1; }
  else { return 0; }
}


/* cookie setting functions
 * 
 * the strtr in the cookie setting functions is NOT encryption. SSL is
 * relied on for the encryption - if you don't use SSL, NONE of this is
 * secure. this is just in case cookie values get displayed on the screen,
 * or something similar. If someone has a better way, please let me know.
 */

$trans_fwd = ' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+=-';
$trans_bck = '1234567890-=ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+abcdefghijklm nopqrstuvwxyz';

function setuser($user) {
  global $default, $SERVER_PORT, $trans_fwd, $trans_bck;
  
  if ($SERVER_PORT == 443 && $default->secure) { $secure = 1; }
  else { $secure = 0; }
  
  setcookie('chuckmIMPuser', strtr($user, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
}

function setpass($pass) {
  global $default, $SERVER_PORT, $trans_fwd, $trans_bck;
  
  if ($SERVER_PORT == 443 && $default->secure) { $secure = 1; }
  else { $secure = 0; }
  
  setcookie('chuckmIMPpass', strtr($pass, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
}

function setsrvr($srvr) {
  global $default, $SERVER_PORT, $trans_fwd, $trans_bck;
  
  if ($SERVER_PORT == 443 && $default->secure) { $secure = 1; }
  else { $secure = 0; }
  
  if ($srvr != '') {
    setcookie('chuckmIMPsrvr', strtr($srvr, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
    return $srvr;
  } else {
    setcookie('chuckmIMPsrvr', strtr( $default->server, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
    return $default->server;
  }
}

function setfldr($fldr) {
  global $default, $SERVER_PORT, $trans_fwd, $trans_bck;
  
  if ($SERVER_PORT == 443 && $default->secure) { $secure = 1; }
  else { $secure = 0; }
  
  if ($fldr != '') {
    setcookie('chuckmIMPfldr', strtr($fldr, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
    return $fldr;
  } else {
    setcookie('chuckmIMPfldr', strtr($default->folders, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
    return $default->folders;
  }
}


/* cookie retrieval functions */

function getuser() {
  global $chuckmIMPuser, $trans_fwd, $trans_bck;
  
  return strtr($chuckmIMPuser, $trans_bck, $trans_fwd);
}

function getpass() {
  global $chuckmIMPpass, $trans_fwd, $trans_bck;
  
  return strtr($chuckmIMPpass, $trans_bck, $trans_fwd);
}

function getsrvr() {
  global $default, $chuckmIMPsrvr, $trans_fwd, $trans_bck;
  
  if (isset($chuckmIMPsrvr)) {
    return strtr($chuckmIMPsrvr, $trans_bck, $trans_fwd);
  } else {
    return $default->server;
  }
}

function getfldr() {
  global $default, $chuckmIMPfldr, $trans_fwd, $trans_bck;
  
  if (isset($chuckmIMPfldr)) {
    return strtr($chuckmIMPfldr, $trans_bck, $trans_fwd);
  } else {
    return $default->folders;
  }
}


function status($message, $status='green') {
  global $status_sent;
  
  echo '<script language="JavaScript">';
  echo 'if (parent.impstatus) {';
  echo 'parent.impstatus.location="status.php3?message=' . urlencode($message) . "&status=$status" . '";';
  echo '}';
  echo '</script>';
  
  $status_sent = true;
}


/* end imp.lib */

?>
