<?php

/*
  
  File : folders.php3
  $Author: chuck $
  $Revision: 1.14 $
  $Date: 1998/08/26 20:32:24 $
  
  IMP : Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
  
  This code is under the GNU Public License
  See the file COPYING in this directory

*/
  
  require( './lib/imp.lib.php3' );      /* IMPlib is the IMP function library  */
  require( './config/defaults.php3' );  /* Defaults configuration file */
  
  error_reporting($default->error_level);  /* set error level from imp.lib.php3   */
  header('Expires: 120');         /* make the page expire in 2 minutes   */
  
  /* retrieve authentication information from cookies */
  $user    = getuser();
  $pass    = getpass();
  $folders = getfldr();
  $server  = getsrvr();
  $mailbox = '';

  /* proceed only with a valid login */
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  
  /* Run through the action handlers */
  
  if (isset($action)) {
    switch($action) {
      case NO_ACTION:
        break;
      
      case DELETE_FOLDER:
        if ($dead_mailbox) {
          if (!(imap_deletemailbox($mbox, "{$server}$dead_mailbox"))) {
	    $errormsg = '<tr><th colspan=5>An error occured; the folder was not deleted.</th></tr>';
	  }
	}
	break;
      
      case CREATE_FOLDER:
        if ($new_mailbox) {
          if (!(imap_createmailbox($mbox, "{$server}$folders/$new_mailbox"))) {
	    $errormsg = '<tr><th colspan=5>An error occured; the new folder was not created</th></tr>';
	  }
	}
	break;
      
      case RENAME_FOLDER:
        if ($old_mailbox && $new_mailbox) {
          if (!(imap_renamemailbox($mbox, "{$server}$old_mailbox", "{$server}$folders/$new_mailbox"))) {
	    $errormsg = '<tr><th colspan=5>An error occured; the folder was not renamed</th></tr>';
	  }
	}
	break;
      
    }
  }
  
  /* close and reopen the imap stream so the mailbox list is up to date */
  imap_close($mbox);
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  $title = "Mail Folders";
  $no_table_frame = true;
  include("$default->include_dir/generic-header_reload.inc");
  
  $options = mailbox_list('INBOX');
  
  include("$default->include_dir/folders.php3-delete.inc");
  include("$default->include_dir/folders.php3-rename.inc");
  include("$default->include_dir/folders.php3-create.inc");
  include("$default->include_dir/generic-footer.inc");
?>
