<?php

/*
   
   File : config/defaults.php3
   $Author: chuck $
   $Revision: 1.11 $
   $Date: 1998/08/21 20:28:27 $
   
   IMP : Copywrite 1998 Charles J. Hagenbuch chuck@osmos.ml.org
   
   This code is under the GNU Public License
   See the file COPYING in this directory
   
*/


/* Imp Defaults Configuration File

This file is for configuring imp's defaults.

The file itself is built around modifying the $default object
that contains sub objects for documents and user flags, options
and other items.

Several configurations are included but are commented out with
block comments like this block of text.
*/

/* Html Configuration

To configure the html for any of the documents you will need
to place values in the ImpDocument class for it.

ImpDocument Class :

class ImpDocument {
   - Html Configuration Elements - 
   var $bg_file;                    - url to a background image -
   var $bg_color;                   - background color -
   var $text_color;                 - text color -
   var $link_color;                 - link color -
   var $vlink_color;                - vlink color -
   var $alink_color;                - alink color -
   - Rest of class is ommited for clarity see
   lib/imp.lib.php3 to see all of it -

Sample:
   Lets modify the main body pages background color to white :
   $default->body->bg_color = '#ffffff'; 
*/

/* set theme colors */
$default->dark_bg                   = '#002266';
$default->light_bg                  = '#e9e9e9';
$default->text_on_light             = '#000000';
$default->text_on_dark              = '#ffffff';
$default->text_bg                   = '#ffffff';
$default->item_bg                   = '#ffffcc';
$default->nav_bg                    = '#dcdcdc';

$default->body->bg_color            = $default->light_bg;
$default->body->bg_file             = '';
$default->body->text_color          = $default->text_on_light;
$default->body->link_color          = '#0000ff';
$default->body->vlink_color         = '#0000aa';
$default->body->alink_color         = '#0000ff';
$default->sidebar->bg_color         = $default->dark_bg;
$default->sidebar->text_color       = $default->text_on_dark;
$default->sidebar->link_color       = '#e0e0e0';
$default->sidebar->vlink_color      = '#dddddd';
$default->sidebar->alink_color      = '#ffffff';
$default->sidebar->logo             = 'impsmall.gif';


/* Server Specific Configuration

Since a lot of the configuration options are changing / being added
I (zero) haven't written much documentation for them. I will in
the future. I provided the sample configs to show what chuck and
I use.

When changing the server specific configuration you address the
ImpDefault object directly. Here is the imp default object:

class ImpDefaults {
  - Html Configuration -
  
  - impmain frame colors -
  var $body;    
      - ImpDocument : configures the impmain frame colors - 
  
  - impmenu (sidebar) frame colors -
  var $sidebar;
      - ImpDocument : configures the impmenu frame colors -

  - URL Configuraton -
  var $graphics_url;
      - imp specfic graphics -

  var $root_url;
      - imp base url -
  
  - IMAP Configuration -
  var $server;
      - default IMAP server to connect to -
  var $folders;
      - default directory to look in for mail folders -
  
  var $secure;
      - Use SSL for cookies if it is a secure connection -
  
  - Imp Server Configuration -
  var $user_change_server;
      - set false to force use of the default server -
  var $user_change_folder;
      - set false to force use of the default folder dir -
  
  - Imp Client Configuration -
  var $max_messages_page;
      - max number of messages to display in one page in mailbox.php3 -
*/

/* Sample Configurations */

/* -- Alpha.jccc.net Configuration --
$default->root_url                  = '/devel';
$default->graphics_url              = $default->root_url . '/graphics';
$default->server                    = 'alpha.jccc.net';  
$default->folders                   = 'mail';
$default->secure                    = true;
$default->user_change_server        = true;
$default->user_change_folder        = true;
$default->error_level               = 1;    
$default->path_to_imap              = '';
$default->path_to_sendmail          = '/usr/sbin/sendmail';
$default->db_lib                    = 'lib/mysql.lib.php3';
$default->include_dir               = './templates';
*/

/* -- Osmos.ml.org Configuration -- */
$default->root_url                  = '/imp';
$default->graphics_url              = $default->root_url . '/graphics';
$default->server                    = 'wso.williams.edu';  
$default->folders                   = 'mail';
$default->secure                    = true;
$default->user_change_server        = true;
$default->user_change_folder        = true;
$default->path_to_imap              = '';
$default->path_to_sendmail          = '/usr/sbin/sendmail';
$default->db_lib                    = 'lib/mysql.lib.php3';
$default->include_dir               = './templates';

?>
