<?php

/*
  
  File : compose.php3
  $Author: zerodiv $
  $Revision: 1.15 $
  $Date: 1998/08/24 18:15:48 $
  
  IMP : Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
  
  This code is under the GNU Public License
  See the file COPYING in this directory
*/
  
  require ('./lib/imp.lib.php3');          /* IMPlib is the IMP function library  */
  require ('./config/defaults.php3');      /* Defaults configuration file         */
  require ($default->db_lib);              /* DBlib is the db backend library     */
  error_reporting($default->error_level);  /* set error level from imp.lib.php3   */
  header('Expires: 0');                    /* make sure the page is not cached    */
  
  $user    = getuser();
  $pass    = getpass();
  $folders = getfldr();
  $server  = getsrvr();
  if (!isset($mailbox)) { $mailbox = 'INBOX'; }
  $get_sig = true;
  
  /* login */
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  /* Run through action handlers */
  
  if (isset($action)) {
    switch ($action) {
      case NO_ACTION:
        status('Message Composition');
        $ACTION_TEXT = 'Message Composition';
        break;
      
      case REPLY:
	if ($mailbox && $index && $bodypart) {
	  $h = imap_header($mbox, $index);
	  if ($h->reply_toaddress) { $to = chop(htmlentities($h->reply_toaddress)); }
	  else { $to = chop(htmlentities($h->fromaddress )); }
	  
	  $msg  = "Quoting $to:\n\n&gt; ";
	  $msg .= htmlentities(fill_paragraphs(imap_fetchbody($mbox, $index, $bodypart), 75, "\n> "));
	  $msg .= "\n";
	  
	  $subject = 'Re: ' . chop(htmlentities($h->subject));
     $ACTION_TEXT = 'Reply : ' . chop( htmlentities( $h->subject ) );
	}
	break;
      
      case REPLY_ALL:
        if ($mailbox && $index && $bodypart) {
	  $h = imap_header($mbox, $index);
	  if ($h->reply_toaddress) { $reply = chop(htmlentities($h->reply_toaddress)); }
	  else { $reply = chop(htmlentities($h->fromaddress )); }
	  
	  /* build up the reply to all addresses */
	  if ($reply != chop(htmlentities($h->fromaddress ))) { $to = $reply . ',' . chop(htmlentities($h->fromaddress )); }
	  else { $to = $reply; }
	  if ( $reply != chop(htmlentities($h->toaddress )) ) { $to .= "," . chop(htmlentities($h->toaddress )); }
	  if ( $h->ccaddress) { $to .= ',' . chop(htmlentities($h->ccaddress )); }
	  
	  $msg  = "Quoting $reply:\n\n&gt; ";
	  $msg .= htmlentities(fill_paragraphs(imap_fetchbody($mbox, $index, $bodypart), 75, "\n> "));
	  $msg .= "\n";
	  
	  $subject = 'Re: ' . chop(htmlentities($h->subject));
     $ACTION_TEXT = 'Reply ALL : ' . chop( htmlentities( $h->subject ) );
      
	}
	break;
      
      case FORWARD:
        if ($mailbox && $index && $bodypart) {
	  $h = imap_header($mbox, $index);
	  if ($h->reply_toaddress) { $from = chop(htmlentities($h->reply_toaddress)); }
	  else { $from = chop(htmlentities($h->fromaddress )); }
	  
	  $msg  = "\n----- Forwarded message from $from -----\n";
	  
	  if ($h->date) { $msg .= 'Date: ' . chop(htmlentities($h->date)) . "\n"; }
	  if ($h->fromaddress) { $msg .= 'From: ' . chop(htmlentities($h->fromaddress)) . "\n"; }
	  if ($h->reply_toaddress) { $msg .= 'Reply-To: ' . chop(htmlentities($h->reply_toaddress)) . "\n"; }
	  if ($h->subject) { $msg .= 'Subject: ' . chop(htmlentities($h->subject)) . "\n"; }
	  if ($h->toaddress) { $msg .= 'To: ' . chop(htmlentities($h->toaddress)) . "\n"; }
	  $msg .= "\n";
	  $msg .= htmlentities(fill_paragraphs(imap_fetchbody($mbox, $index, $bodypart)));
	  $msg .= "\n----- End forwarded message -----\n";
	  
	  $subject = 'Fwd: ' . chop(htmlentities($h->subject));
     $ACTION_TEXT = 'Forward : ' . chop( htmlentities( $h->subject ) );
	}
	break;
      
      case SEND_MESSAGE:
        if ($to && $message) {
  	  
	  /* somehow need to verify email addresses */
	  
	  // move these checks into javascript expand function
	  if ( !eregi('@', $to) ) { $to .= "@$server"; }
	  if ( (strlen($cc) > 0) && !eregi('@', $cc) ) { $cc .= "@$server"; }
	  
	  if ($file_upload_size > 0) {
	    $fd = fopen( $file_upload, "r" );
	    $contents = fread( $fd, $file_upload_size);
	    fclose( $fd ); 
	    unlink($file_upload);
	    
	    /* Open the uploaded file, read the contents close it and delete it */                                       
	    $boundary = '-' . md5($contents);
	    
	    /* Create a (semi) unique string, to delimit the parts */
	    $mime_start = "This message is in MIME format.\n";
	    $mime_start .= "\n--$boundary\n";
	    $mime_start .= "Content-Type: TEXT/PLAIN;\n\n";
	    
	    /* Create a text part */
	    $message = fill_paragraphs($message, 80, "\n", '+');
	    
	    /* Wrap the text part */
	    $message = $mime_start . $message;
	    $message .= "\n--$boundary\n";
	    
	    /* Create a part for the attached file, give type & name  and attach the contents, base-64 encoded */
	    $message .=  'Content-Type: ' . $file_upload_type . '; name="' . $file_upload_name . '"' . "\n";
	    $message .= "Content-Transfer-Encoding: BASE64\n\n";
	    $message .= base64_encode($contents);
	    
	    if ($file_upload_size < 100000) {
	      $msg = fill_paragraphs($message, 80, "\n", '');
	    } else { $msg = $message; }
	    
	    /* Prepend nothing, when attaching, if larger than 100K, do not wrap */
	    
	  } else {
	    $msg = fill_paragraphs($message, 80, "\n", '+');
	  }
	  
	  $hdrs  = "Errors-To: $user@$server\n";
	  if ($cc != '') { $hdrs .= "Cc: $cc\n"; }
	  if ($file_upload_size > 0) {
	    $hdrs .= "MIME-Version: 1.0\n";
	    $hdrs .= 'Content-Type: MULTIPART/MIXED; BOUNDARY="' . $boundary . '"'. "\n";
	    /* Include the standard multipart mime headers */
	  }
	  
	  $hdrs .= 'X-Mailer: IMP/PHP3 Imap webMail Program ' . IMP_VERSION;
	  $hdrs .= "\n";    
	  if ( mailfrom($to, "$user@$server", $subject, $hdrs, $msg) ) {
	     status('Message sent successfully.');
	    
	    $fcc  = 'Date: ' . date("D, d M H:i:s Y ") . gm_offset() . "\n";
	    $fcc .= 'To: ' . $to . "\n";
	    $fcc .= 'Subject: ' . $subject . "\n";
	    $fcc .= $hdrs;
	    $fcc .= "\n";
	    $fcc .= $msg;
	    
	    if ( !(imap_append($mbox, "{$server}$folders/sent-mail", $fcc, OP_SHORTCACHE)) ) {
	      status('Message send successfully, ERROR: not saved to sent-mail');
	    }
	  }
	  
	  unset($to);
	  unset($cc);
	  unset($subject);
	  unset($message);
	  unset($msg);
	  
	} else {
	  status('One or more required fields was left empty.', 'red');
	  $get_sig = false;
	  $msg = $message;
	  if ($file_upload_size > 0) {
	    unlink($file_upload);
	    /* Delete the attachment the user tried to send. */
	  }
	}
	
	break;
      
      case POSTPONE_MESSAGE:
        $hdrs  = "Errors-To: $user@$server\n";
	if ($to != '') { $hdrs .= "To: $to\n"; }
	if ($cc != '') { $hdrs .= "Cc: $cc\n"; }
	if ($subject != '') { $hdrs .= "Subject: $subject\n"; }
	$hdrs .= 'X-Mailer: IMP/PHP3 Imap webMail Program ' . IMP_VERSION;
	$hdrs .= "\n\n";
	
	$msg = $hdrs . $message;
	
	imap_createmailbox($mbox, "{$server:143}$folders/postponed-msgs");
	if ( !(imap_append($mbox, "{$server:143}$folders/postponed-msgs", $msg, OP_SHORTCACHE)) ) {
          status('Error: Message Postponement failed', 'red');
	  $get_sig = false;
	}
	else {
	  status('Message Postponed');
	  unset($to);
	  unset($cc);
	  unset($subject);
	  unset($message);
	  unset($msg);
	}
        
	break;
    
    }
  }
  if (!isset($status_sent)) { status('Message Composition'); }
  
  
  $title = 'Message Composition';
  include("$default->include_dir/generic-header.inc");
  
  if ( $get_sig && $sig = imp_get_signature($user, $server)) { $msg .= "\n\n\n" . $sig; }
  
  $addresses = imp_get_addresses($user, $server);
  
  $options = '<option value=\'\'>add address:</option>';
  for ($i = 0; $i < count($addresses); $i++) {
    $options .= '<option value="' . $addresses[$i][0] . '">' . $addresses[$i][1] . ' &lt;' . $addresses[$i][0] . "&gt;\n";
  }
  
  include("$default->include_dir/compose.php3-compose.inc");
  include("$default->include_dir/generic-footer.inc");
  include("$default->include_dir/compose.php3-javascript.inc");
?>
