<?php

/*
  
  File : addressbook.php3
  $Author: chuck $
  $Revision: 1.9 $
  $Date: 1998/08/21 15:45:02 $
  
  addressbook.php3
  
  IMP v1.5
  Copyright 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
  
  This code is under the GNU Public License
  See the file COPYING in this directory
*/
  
  require ('./lib/imp.lib.php3');            /* IMPlib is the IMP function library  */
  require ('./config/defaults.php3');        /* Defaults Configuration File */
  require ($default->db_lib);              /* DBlib is the db backend library     */
  error_reporting($default->error_level);  /* set error level from imp.lib.php3   */
  header('Expires: 120');                  /* make the page expire in 2 minutes   */
  
  /* retrieve authentication information from cookies */
  $user    = getuser();
  $pass    = getpass();
  $folders = getfldr();
  $server  = getsrvr();
  $mailbox = '';
  
  /* proceed only with a valid login */
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  
  /* Run through the action handlers */
  if (isset($action)) {
    switch($action) {
      case NO_ACTION:
        break;
      
      case DELETE_ADDR:
        if ($dead_address) {
	  if (!(imp_delete_address($dead_address, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; the entry was not deleted from your addressbook.</th></tr>';
	  }
	}
	break;
      
      case ADD_ADDR:
        if ($new_address && $new_nickname && $new_fullname) {
	  $clean_nickname = eregi_replace(' ', '', $new_nickname);
	  $clean_fullname = eregi_replace(',', '', $new_fullname);
	  $clean_fullname = eregi_replace('\'', '', $clean_fullname);
	  $clean_fullname = eregi_replace('"', '', $clean_fullname);
	  $clean_address = eregi_replace(',', '', $new_address);
	  $clean_address = eregi_replace('\'', '', $clean_address);
	  $clean_address = eregi_replace('"', '', $clean_address);
	  $clean_address = eregi_replace(' ', '', $clean_address);
	  
	  if ($clean_address != $new_address) { $errormsg .= '<tr><th>You used an illegal character in the email address. It has been entered without it; edit it if you want to change the resulting entry.</th></tr>'; }
	  if ($clean_nickname != $new_nickname) { $errormsg .= '<tr><th>You used an illegal character in the nickname. It has been entered without it; edit it if you want to change the resulting entry.</th></tr>'; }
	  if ($clean_fullname != $new_fullname) { $errormsg .= '<tr><th>You used an illegal character in the full name. It has been entered without it; edit it if you want to change the resulting entry.</th></tr>'; }
	  
	  if (!(imp_add_address($clean_address, $clean_nickname, $clean_fullname, $user, $server))) {
	    $errormsg .= '<tr><th>An error occured; the entry was not created.</th></tr>';
	  }
	}
	break;
      
      case UPDATE_ADDR:
        if ($old_address && $new_address && $new_nickname && $new_fullname) {
	  if (!(imp_update_address($old_address, $new_address, $new_nickname, $new_fullname, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; the entry was not changed.</th></tr>';
	  }
	}
	break;
    }
  }
  
  
  $title = "Addressbook";
  include("$default->include_dir/generic-header.inc");
  
  $addresses = imp_get_addresses($user, $server);
  
  for ($i = 0; $i < count($addresses); $i++) {
    $options .= '    <option value="' . $addresses[$i][0] . '">' . $addresses[$i][1] . ' &lt;' . $addresses[$i][0] . "&gt;\n";
  }
  
  include("$default->include_dir/addressbook.php3-create.inc");
  include("$default->include_dir/addressbook.php3-update.inc");
  include("$default->include_dir/addressbook.php3-delete.inc");
  include("$default->include_dir/generic-footer.inc");
  include("$default->include_dir/addressbook.php3-javascript.inc");
?>
