<?php

/*
   
	File : lib/imp.lib.php3
	$Author: chuck $
	$Revision: 1.14 $
	$Date: 1998/08/19 03:42:07 $

   IMP : Copywrite 1998 Charles J. Hagenbuch chuck@osmos.ml.org
   
   This code is under the GNU Public License
   See the file COPYING in this directory
*/

class ImpDefaults {
  /* Html Configuration */
  
  /* impmain frame colors */
  var $body_bg_file;				/* url to a background image */
  var $body_bg_color;				/* background color */
  var $body_text_color;				/* text color */
  var $body_link_color;				/* link color */
  var $body_vlink_color;			/* vlink color */
  var $body_alink_color;			/* alink color */
  
  /* impmenu (sidebar) frame colors */
  var $sidebar_bg_color;                        /* sidebar background color */
  var $sidebar_bg_file;                         /* sidebar background picture */
  var $sidebar_text_color;                      /* sidebar text color */
  var $sidebar_link_color;                      /* sidebar link color */
  var $sidebar_vlink_color;                     /* sidebar vlink color */
  var $sidebar_alink_color;                     /* sidebar alink color */
  var $sidebar_imp_logo;                        /* imp logo */
  
  
  /* URL Configuraton */
  var $graphics_url;				/* imp specfic graphics */
  var $root_url;				/* imp base url */
  
  /* IMAP Configuration */
  var $server;	 				/* default IMAP server to connect to */
  var $folders;					/* default directory to look in for mail folders     */
  
  var $secure;					/* Use SSL for cookies if it is a secure connection  */
  
  /* Imp Server Configuration */
  var $user_change_server; 			/* set false to force use of the default server      */
  var $user_change_folder;			/* set false to force use of the default folder dir  */
  
  /* Imp Client Configuration */
  var $max_messages_page; 			/* max number of messages to display in one page in mailbox.php3  */
  
  Function ImpDefaultsInit() {
    $this->body_bg_file				= '';
    $this->body_bg_color			= '#e9e9e9';
    $this->body_text_color			= '#000000';
    $this->body_link_color			= '#0000FF';
    $this->body_vlink_color			= '#0000AA';
    $this->body_alink_color			= '#0000FF';
    $this->max_messages_page			= 50;
    
    /* -- Alpha.jccc.net Configuration --
    $this->root_url				= '/devel';
    $this->graphics_url				= $this->root_url . '/graphics';
    $this->server  				= 'alpha.jccc.net';  
    $this->folders				= 'mail/';
    $this->secure  				= true;
    $this->user_change_server			= true;
    $this->user_change_folder			= true;
    */
    
    /* -- Osmos.ml.org Configuration -- */
    $this->root_url				= '/imp/';
    $this->graphics_url				= '/imp/graphics/';
    $this->server  				= 'wso.williams.edu';  
    $this->folders				= 'mail/';
    $this->secure 				= true;
    $this->user_change_server			= true;
    $this->user_change_folder			= true;
    
  }
}


/* USER Defaults */

class ImpUserDefaults {
  /* Html Configuration */
  var $body_bg_file;				/* url to a background image */
  var $body_bg_color;				/* background color */
  var $body_text_color;				/* text color */
  var $body_link_color;				/* link color */
  var $body_vlink_color;			/* vlink color */
  var $body_alink_color;			/* alink color */
  
  /* Imp Client Configuration */
  var $max_messages_page; 			/* max number of messages to display in one page in mailbox.php3  */
  
  Function ImpUserDefaultsInit() {
  }
}

/*
	DEFAULTS :

	Depricated Variables : 
	Old Variable : 		      New Variable :
	$imp_graphics 	       ->  	$default->graphics_url
	$imp_root		       ->	$default->root_url
	$default_server       ->   $default->server
	$default_folders      ->   $default->folders
	$default_secure       ->   $default->secure
	$user_change_server   ->   $default->user_change_server
	$user_change_folder   -> 	$default->user_change_folder
	$max_messages_page	 ->	$default->max_messages_page
*/


$error_level = 1;                           /* level of error_reporting()  */

$path_to_db_lib   = 'lib/mysql.lib.php3';
$path_to_sendmail = '/usr/sbin/sendmail';
$path_to_imap     = '';


/* Initialization */

if ($path_to_imap) { dl($path_to_imap); }   /* load the imap module if needed  */

/* Init Defaults Object */
$default = new ImpDefaults;
$default->ImpDefaultsInit();



/* Functions */


/* function to wrap text at $wrap, semi-gracefully */

function fill_paragraphs($text, $wrap=80, $break="\n") {
  $lines = explode("\n", $text);
  
  $i = 0;
  
  while ($i < sizeof ($lines)) {
    if (strlen($lines[$i]) < $wrap) {
      $result[count($result)] = $lines[$i];
      $i++;
    } else {
      $result[count($result)] = substr($lines[$i], 0, $wrap);
      $lines[$i] = "+" . substr($lines[$i], $wrap, strlen($lines[$i]) - $wrap);
    }
  }
  return implode($break, $result);
}


/* obtain the -0400 or whatever it is for you offset for the date header */

function gm_offset() {
  $offset = ((date("H") - gmdate("H")));
  if ($offset >= 0) { return sprintf("+%02d", $offset) . "00"; }
  else { return sprintf("-%02d", -$offset) . "00"; }
}


/* make sure the user has a valid login; if so, return an imap stream */

function validate_login($server, $mailbox, $user, $pass) {
  if (! ($mbox = imap_open("{$server:143}$mailbox", $user, $pass)) ) {
    echo '<script language=javascript>
          <!--
	  document.location="login.php3?reason=timeout";
	  //-->
	  </script>
    ';
  }
  return $mbox;
}


/* function that interfaces to sendmail, so from address and all headers
 * are set correctly
 */

function mailfrom($to, $from, $subject, $hdrs, $message) {
  global $path_to_sendmail;
  
  $mail = popen("$path_to_sendmail -t -f '$from'", 'w');
  
  $result  = fputs($mail, "To: $to\n");
  $result += fputs($mail, "From: $from\n");
  $result += fputs($mail, $hdrs);
  $result += fputs($mail, "Subject: $subject\n\n");
  $result += fputs($mail, $message);
  
  pclose($mail);
  
  if ($result > 0) { return 1; }
  else { return 0; }
}


/* cookie setting functions
 * 
 * the strtr in the cookie setting functions is NOT encryption. SSL is
 * relied on for the encryption - if you don't use SSL, NONE of this is
 * secure. this is just in case cookie values get displayed on the screen,
 * or something similar. If someone has a better way, please let me know.
 */

$trans_fwd = ' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+=-';
$trans_bck = '1234567890-=ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+abcdefghijklm nopqrstuvwxyz';

function setuser($user) {
  global $default, $SERVER_PORT, $trans_fwd, $trans_bck;
  
  if ($SERVER_PORT == 443 && $default->secure) { $secure = 1; }
  else { $secure = 0; }
  
  setcookie('chuckmIMPuser', strtr($user, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
}

function setpass($pass) {
  global $default, $SERVER_PORT, $trans_fwd, $trans_bck;
  
  if ($SERVER_PORT == 443 && $default->secure) { $secure = 1; }
  else { $secure = 0; }
  
  setcookie('chuckmIMPpass', strtr($pass, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
}

function setsrvr($srvr) {
  global $default, $SERVER_PORT, $trans_fwd, $trans_bck;
  
  if ($SERVER_PORT == 443 && $default->secure) { $secure = 1; }
  else { $secure = 0; }
  
  if ($srvr != '') {
    setcookie('chuckmIMPsrvr', strtr($srvr, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
    return $srvr;
  } else {
    setcookie('chuckmIMPsrvr', strtr( $default->server, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
    return $default->server;
  }
}

function setfldr($fldr) {
  global $default, $SERVER_PORT, $trans_fwd, $trans_bck;
  
  if ($SERVER_PORT == 443 && $default->secure) { $secure = 1; }
  else { $secure = 0; }
  
  if ($fldr != '') {
    setcookie('chuckmIMPfldr', strtr($fldr, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
    return $fldr;
  } else {
    setcookie('chuckmIMPfldr', strtr($default->folders, $trans_fwd, $trans_bck), "time()+900", $default->root_url, '', $secure);
    return $default->folders;
  }
}


/* cookie retrieval functions */

function getuser() {
  global $chuckmIMPuser, $trans_fwd, $trans_bck;
  
  return strtr($chuckmIMPuser, $trans_bck, $trans_fwd);
}

function getpass() {
  global $chuckmIMPpass, $trans_fwd, $trans_bck;
  
  return strtr($chuckmIMPpass, $trans_bck, $trans_fwd);
}

function getsrvr() {
  global $default, $chuckmIMPsrvr, $trans_fwd, $trans_bck;
  
  if (isset($chuckmIMPsrvr)) {
    return strtr($chuckmIMPsrvr, $trans_bck, $trans_fwd);
  } else {
    return $default->server;
  }
}

function getfldr() {
  global $default, $chuckmIMPfldr, $trans_fwd, $trans_bck;
  
  if (isset($chuckmIMPfldr)) {
    return strtr($chuckmIMPfldr, $trans_bck, $trans_fwd);
  } else {
    return $default->folders;
  }
}


/* end imp.lib */

?>
