<?php

/*
 
	File : folders.php3
	$Author: chuck $
	$Revision: 1.7 $
	$Date: 1998/08/19 03:21:17 $

   IMP : Copywrite 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
   
   This code is under the GNU Public License
   See the file COPYING in this directory
*/
  
  require ('lib/imp.lib.php3');   /* IMPlib is the IMP function library  */
  error_reporting($error_level);  /* set error level from imp.lib.php3   */
  header('Expires: 120');         /* make the page expire in 2 minutes   */
  
  /* retrieve authentication information from cookies */
  $user    = getuser();
  $pass    = getpass();
  $folders = getfldr();
  $server  = getsrvr();
  $mailbox = '';

  /* proceed only with a valid login */
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  
  /* Run through the action handlers */
  
  /* Actions
     0 - nothing
     1 - delete folder
     2 - create folder
     3 - rename folder
  */
  
  if (isset($action)) {
    switch($action) {
      case 0:
        break;
      
      case 1:
        if ($dead_mailbox) {
          if (!(imap_deletemailbox($mbox, "{$server}$dead_mailbox"))) {
	    $errormsg = '<tr><th colspan=5>An error occured; the folder was not deleted.</th></tr>';
	  }
	}
	break;
      
      case 2:
        if ($new_mailbox) {
          if (!(imap_createmailbox($mbox, "{$server}$folders$new_mailbox"))) {
	    $errormsg = '<tr><th colspan=5>An error occured; the new folder was not created</th></tr>';
	  }
	}
	break;
      
      case 3:
        if ($old_mailbox && $new_mailbox) {
          if (!(imap_renamemailbox($mbox, "{$server}$old_mailbox", "{$server}$folders$new_mailbox"))) {
	    $errormsg = '<tr><th colspan=5>An error occured; the folder was not renamed</th></tr>';
	  }
	}
	break;
      
    }
  }
  
  /* close and reopen the imap stream so the mailbox list is up to date */
  imap_close($mbox);
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  $title = "Mail Folders";
  $no_table_frame = true;
  include('templates/generic-header_reload.inc');
  
  $mboxes = imap_listmailbox($mbox, "{$server}", "$folders/*");
  
  $options = '';
  for ($i = 0; $i < count($mboxes); $i++) {
    $label = eregi_replace("{$server}$folders/*", '', $mboxes[$i]);
    $value = "$folders/$label";
    $options .= "    <option value=\"$value\">$label</option>\n";
  }
  
  include('templates/folders.php3-delete.inc');
  include('templates/folders.php3-rename.inc');
  include('templates/folders.php3-create.inc');
  include('templates/generic-footer.inc');
?>
