<?php

/*
   addressbook.php3
   
   IMP v1.5
   Copywrite 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
   
   This code is under the GNU Public License
   See the file COPYING in this directory
*/
  
  error_reporting(1);            /* surpress imap_stream errors, etc.   */
  require ('lib/imp.lib.php3');  /* IMPlib is the IMP function library  */
  require ($path_to_db_lib);     /* DBlib is the db backend library     */
  dl($path_to_imap);             /* load the imap module                */
  header('Expires: 120');        /* make the page expire in 2 minutes   */
  
  /* retrieve authentication information from cookies */
  $user    = getuser();
  $pass    = getpass();
  $folders = getfldr();
  $server  = getsrvr();
  $mailbox = '';
  
  /* proceed only with a valid login */
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  
  /* Actions
      0 - delete entry
      1 - add entry
      2 - change entry
  */
  
  /* Run through the action handlers */
  if (isset($action)) {
    switch($action) {
      case 0:
        if ($dead_address) {
	  if (!(imp_delete_address($dead_address, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; the entry was not deleted from your addressbook.</th></tr>';
	  }
	}
      
      case 1:
        if ($new_address && $new_nickname) {
	  if (!(imp_add_address($new_address, $new_nickname, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; the entry was not created.</th></tr>';
	  }
	}
      
      case 2:
        if ($old_address && $new_address && new_nickname) {
	  if (!(imp_update_address($old_address, $new_address, $new_nickname, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; the entry was not changed.</th></tr>';
	  }
	}
    }
  }
  
  $title = "Addressbook";
  $header_template = file('templates/generic-header.inc');
  $header_template = implode($header_template, '');
  fill_template($header_template, '$title, $errormsg');
  
  $addresses = imp_get_addresses($user, $server);
  
  for ($i = 0; $i < count($addresses); $i++) {
    echo htmlentities($addresses[$i]);
  }
  
  $footer_template = file('templates/generic-footer.inc');
  $footer_template = implode($footer_template, '');
  fill_template($footer_template, '$mbox');
?>
