<?php

/*
   mailbox.php3
   
   IMP v1.5
   Copywrite 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
   
   This code is under the GNU Public License
   See the file COPYING in this directory
*/
  
  require ('lib/imp.lib.php3');   /* IMPlib is the IMP function library  */
  error_reporting($error_level);  /* set error level from imp.lib.php3   */
  
  /* Set or read cookies */
  if ($action != 6) {
    $user    = getuser();
    $pass    = getpass();
    $folders = getfldr();
    $server  = getsrvr();
  } else {
    setuser($user);
    setpass($pass);
    $server  = setsrvr($server);
    $folders = setfldr($folders);
  }
  
  header('Expires: 120');         /* make the page expire in 2 minutes   */
  
  if (!isset($mailbox)) { $mailbox = 'INBOX'; }
  if (!isset($start)) { $start = 1; }
  $current_mbox = eregi_replace("{$server}$folders/*", '', $mailbox);
  
  /* only proceed on a valid login */
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  
  /* Run through the action handlers */
  
  /* Actions:
     0 - nothing
     1 - delete messages
     2 - undelete messages
     3 - move messages
     4 - copy messages
     5 - expunge messages
     6 - login
  */
  
  if (isset($action)) {
    
    if (substr($indices, -0, 1) == ',') {
      $indices = substr($indices, 0, strlen($indices) - 1);
    }
    
    switch ($action) {
      case 0;
        break;
      
      case 1:
        if ($indices && $mailbox) {
	  $indices = split(',', $indices);
	  for ($i = 0; $i < count($indices); $i++) {
	    if (!(imap_delete($mbox, $indices[$i]))) {
	      $errormsg = '<tr><th colspan=5>An error occured; some or all of your messages have not been deleted.</th></tr>';
	    }
	  }
	}
	break;
      
      case 2:
        if ($mailbox && $indices) {
	  $indices = split(',', $indices);
	  for ($i = 0; $i < count($indices); $i++) {
	    if (!(imap_undelete($mbox, $indices[$i]))) {
	      $errormsg = '<tr><th colspan=5>An error occured; some or all of your messages were not undeleted</th></tr>';
	    }
	  }
	}
	break;
      
      case 3:
        if ($target && $indices) {
	  if (! (imap_mail_move($mbox, $indices, $target)) ) {
	    $errormsg = '<tr><th colspan=5>An error occured; some or all of your messages were not moved.</th></tr>';
	  }
	}
	break;
      
      case 4:
        if ($target && $indices) {
	  if (!(imap_mail_copy($mbox, $indices, $target)) ) {
	    $errormsg = '<tr><th colspan=5>An error occured; some or all of your messages were not copied.</th></tr>';
	  }
	}
	break;
      
      case 5:
        if ($mailbox) {
	  if (!(imap_expunge($mbox))) {
	    $errormsg = '<tr><th colspan=5>An error occured; the mailbox was not expunged</th></tr>';
	  }
	}
	break;
      
      case 6:
        echo '<script language="JavaScript">
              <!--
	      if (parent.impmenu) {
	        parent.impmenu.location="menu.php3";
	      }
	      //-->
	      </script>';
	break;
    }
  }
  
  $title = "Index of $current_mbox";
  include('templates/generic-header.inc');
  
  
  $nummsgs = imap_num_msg($mbox);
  
  if ($nummsgs < $max_messages_page) { $start = 1; }
  elseif ($nummsgs - $start < $max_messages_page) { $start = $nummsgs - $max_messages_page; }
  
  if ($nummsgs < $start + $max_messages_page) { $end = $nummsgs; }
  else { $end = $start + $max_messages_page; }
  
  /* figure out whether to include the prev/next page links or not, and if so,
   * what to index them at. */
  
  if ($nummsgs > $max_messages_page) {
    if ($start > 1) {
      if ($start - $max_messages_page >= 1) { $prevstart = $start - $max_messages_page; }
      else { $prevstart = 1; }
      $mailbox_navigation .= "<a href=\"mailbox.php3?mailbox=$mailbox&start=$prevstart\">previous page</a> ";
    }
    if ($start + $max_messages_page < $nummsgs) {
      $nextstart = $start + $max_messages_page;
      $mailbox_navigation .= "<a href=\"mailbox.php3?mailbox=$mailbox&start=$nextstart\">next page</a> ";
    }
  }
  
  $check=imap_check($mbox);
  include('templates/mailbox.php3-header.inc');
  
  $mboxes = imap_listmailbox($mbox, "{$server}", "$folders/*");
  
  $options  = '<option value="">selected mail to:</option>';
  if ($mailbox != 'INBOX') { $options .= '<option value="INBOX">Inbox</option>'; }
  for ($i = 0; $i < count($mboxes); $i++) {
    $label = eregi_replace("{$server}$folders/*", '', $mboxes[$i]);
    $value = "$folders/$label";
    if ($mailbox != $mboxes[$i]) { $options .= "<option value=\"$value\">$label</option>\n"; }
  }
  
  $form_num = 1;
  include('templates/mailbox.php3-navbar.inc');
  include('templates/mailbox.php3-actions.inc');
  include('templates/mailbox.php3-message_headers.inc');
  
  for ($i=$start; $i <= $end; $i++) {
    if (! imap_ping($mbox) ) {
      $mbox = imap_open("{$server}$mailbox",$user,$pass);
    }
    
    $h=imap_header($mbox,$i);
    
    $dat = chop(substr(htmlentities($h->date), 0, 11));
    $frm = chop(htmlentities($h->fromaddress));
    $sub = chop(htmlentities($h->subject));
    
    if ($dat == '') { $dat = '&nbsp;'; }
    if ($frm == '') { $frm = '&nbsp;'; }
    if ($sub == '') { $sub = '[no subject]'; }
    
    include('templates/mailbox.php3-message_summaries.inc');
  }
  
  include('templates/mailbox.php3-message_footers.inc');
  include('templates/mailbox.php3-actions.inc');
  
  $form_num = 2;
  include('templates/mailbox.php3-navbar.inc');
  include('templates/generic-footer.inc');
  include('templates/mailbox.php3-javascript.inc');
?>
