<?php

/*
   mailbox.php3
   
   IMP v1.5
   Copywrite 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
   
   This code is under the GNU Public License
   See the file COPYING in this directory
*/
  
  error_reporting(1);            /* surpress imap_stream errors, etc.   */
  require ('lib/imp.lib.php3');  /* IMPlib is the IMP function library  */
  dl($path_to_imap);             /* load the imap module                */
  header('Expires: 120');        /* make the page expire in 2 minutes   */
  
  /* Set or read cookies */
  if ($action != 5) {
    $user    = getuser();
    $pass    = getpass();
    $folders = getfldr();
    $server  = getsrvr();
  } else {
    setuser($user);
    setpass($pass);
    $server  = setsrvr($server);
    $folders = setfldr($folders);
  }
  
  if (!isset($mailbox)) { $mailbox = 'INBOX'; }
  if (!isset($start)) { $start = 1; }
  $current_mbox = eregi_replace("{$server}$folders/*", '', $mailbox);
  
  /* only proceed on a valid login */
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  
  /* Run through the action handlers */
  
  /* actions:
     0 - delete
     1 - undelete
     2 - move
     3 - copy
     4 - expunge
     5 - login
  */
  
  if (isset($action)) {
    
    if (substr($indices, -0, 1) == ',') {
      $indices = substr($indices, 0, strlen($indices) -1);
    }
    
    switch ($action) {
      case 0:
        if ($indices && $mailbox) {
	  $indices = split(',', $indices);
	  for ($i = 0; $i < count($indices); $i++) {
	    if (!(imap_delete($mbox, $indices[$i]))) {
	      $errormsg = '<tr><th colspan=5>An error occured; some or all of your messages have not been deleted.</th></tr>';
	    }
	  }
	}
	break;
      
      case 1:
        if ($mailbox && $indices) {
	  $indices = split(',', $indices);
	  for ($i = 0; $i < count($indices); $i++) {
	    if (!(imap_undelete($mbox, $indices[$i]))) {
	      $errormsg = '<tr><th colspan=5>An error occured; some or all of your messages were not undeleted</th></tr>';
	    }
	  }
	}
	break;
      
      case 2:
        if ($target && $indices) {
	  if (! (imap_mail_move($mbox, $indices, $target)) ) {
	    $errormsg = '<tr><th colspan=5>An error occured; some or all of your messages were not moved.</th></tr>';
	  }
	}
	break;
      
      case 3:
        if ($target && $indices) {
	  if (!(imap_mail_copy($mbox, $indices, $target)) ) {
	    $errormsg = '<tr><th colspan=5>An error occured; some or all of your messages were not copied.</th></tr>';
	  }
	}
	break;
      
      case 4:
        if ($mailbox) {
	  if (!(imap_expunge($mbox))) {
	    $errormsg = '<tr><th colspan=5>An error occured; the mailbox was not expunged</th></tr>';
	  }
	}
	break;
      
      case 5:
        echo '<script language="JavaScript">
              <!--
	      if (parent.impmenu) {
	        parent.impmenu.location="menu.php3";
	      }
	      //-->
	      </script>';
	break;
    }
  }
  
  $title = "Index of $current_mbox";
  include('templates/generic-header.inc');
?>

<tr><td colspan=5 bgcolor=002266 align=center>
<table border=0 width="100%" cellpadding=0 cellspacing=0><tr>

<?php
  $nummsgs = imap_num_msg($mbox);
  
  if ($nummsgs < $max_messages_page) { $start = 1; }
  elseif ($nummsgs - $start < $max_messages_page) { $start = $nummsgs - $max_messages_page; }
  
  if ($nummsgs < $start + $max_messages_page) { $end = $nummsgs; }
  else { $end = $start + $max_messages_page; }
  
  /* figure out whether to include the prev/next page links or not, and if so,
   * what to index them at. */
  
  if ($nummsgs > $max_messages_page) {
    if ($start > 1) {
      if ($start - $max_messages_page >= 1) { $prevstart = $start - $max_messages_page; }
      else { $prevstart = 1; }
      $mailbox_navigation .= "<a href=\"mailbox.php3?mailbox=$mailbox&start=$prevstart\">previous page</a> ";
    }
    if ($start + $max_messages_page < $nummsgs) {
      $nextstart = $start + $max_messages_page;
      $mailbox_navigation .= "<a href=\"mailbox.php3?mailbox=$mailbox&start=$nextstart\">next page</a> ";
    }
  }
  
  $check=imap_check($mbox);
  
  echo "<td align=left width=\"33%\"><font color=ffffff><b>$current_mbox</b></font></td>\n";
  echo "<td align=center width=\"33%\"><font color=ffffff><i>",substr($check->Date, 0, 11),"</i></font></td>\n";
  echo "<td align=right width=\"33%\"><font color=ffffff><b>$start - $end of $nummsgs Messages</b></font></td>\n";
?>

</tr></table></td></tr>

<tr><td bgcolor=dcdcdc>&nbsp;</td><td bgcolor=dcdcdc colspan=4>
  <table border=0 width="100%"><tr><td align=left>
    <font face="Arial,Helvetica" size=2>
    <a href="javascript:Submit(0)">[Delete]</a> 
    <a href="javascript:Submit(1)">[Undelete]</a> 
    selected mail
    </font>
  </td>
  
  <form name=transfer1 action="mailbox.php3" method=post>
  
<?php
  $mboxes = imap_listmailbox($mbox, "{$server}", "$folders/*");
  
  $options  = '<option value="">selected mail to:</option>';
  if ($mailbox != 'INBOX') { $options .= '<option value="INBOX">Inbox</option>'; }
  for ($i = 1; $i < count($mboxes); $i++) {
    $label = eregi_replace("{$server}$folders/*", '', $mboxes[$i]);
    if ($mailbox != $mboxes[$i]) { $options .= "<option value=\"$mboxes[$i]\">$label</option>\n"; }
  }
?>
  
  <td align=right>
    <font face="Arial,Helvetica" size=2>
    
    <a href="javascript:Transfer(2, 1)">[Move]</a>
    <a href="javascript:Transfer(3, 1)">[Copy]</a> 
    <select name=target>
    <? echo $options,"\n"; ?>
    </select>
    
    </font>
  </td>
  
  <?php echo "<input type=hidden name=mailbox value=\"$mailbox\">\n"; ?>
  <input type=hidden name=action value="">
  <input type=hidden name=indices value="">
  </form>
  
  </tr></table>
</td></tr>

<tr><td bgcolor=ffffff>&nbsp;</td><td bgcolor=ffffff colspan=3>
  <table border=0 width="100%"><tr><td width="33%" align=left>
    <font face="Arial,Helvetica" size=2>
    <a href="javascript:ToggleAll(true)">select all</a> - 
    <a href="javascript:ToggleAll(false)">select none</a>
    </font>
  </td><td width="33%" align=center>
    <font face="Arial,Helvetica" size=2>
    <? echo $mailbox_navigation,"\n"; ?>
    </font>
  </td><td width="33%" align=right>
    <font face="Arial,Helvetica" size=2>
    <? echo "<a href=\"mailbox.php3?action=4&mailbox=$mailbox\">empty trash</a>\n"; ?>
    </font>
  </td></tr></table>
</td><td bgcolor=ffffff>&nbsp;</td></tr>

<tr>
<th bgcolor=ffffcc align=left>&nbsp;</th>
<th bgcolor=ffffcc align=left><font face="Arial,Helvetica">Date&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</font></th>
<th bgcolor=ffffcc align=left><font face="Arial,Helvetica">From</font></th>
<th bgcolor=ffffcc align=left><font face="Arial,Helvetica">Subject</font></th>
<th bgcolor=ffffcc width=10><font face="Arial,Helvetica">Del?</font></th>
</tr>

<form action="mailbox.php3" method=post name=messages>

<?php
  for ($i=$start; $i <= $end; $i++) {
    if (! imap_ping($mbox) ) {
      $mbox = imap_open("{$server}$mailbox",$user,$pass);
    }
    
    $h=imap_header($mbox,$i);
    
    $dat = chop(substr(htmlentities($h->date), 0, 11));
    $frm = chop(htmlentities($h->fromaddress));
    $sub = chop(htmlentities($h->subject));
    
    if ($dat == '') { $dat = '&nbsp;'; }
    if ($frm == '') { $frm = '&nbsp;'; }
    if ($sub == '') { $sub = '[no subject]'; }
    
    include('templates/mailbox.php3-message_summaries.inc');
  }
  echo "<input type=hidden name=mailbox value=\"$mailbox\">\n";
?>

<input type=hidden name=action value="">
<input type=hidden name=indices value="">
</form>

<tr><td bgcolor=ffffff>&nbsp;</td><td bgcolor=ffffff colspan=3>
  <table border=0 width="100%"><tr><td width="33%" align=left>
    <font face="Arial,Helvetica" size=2>
    <a href="javascript:ToggleAll(true)">select all</a> - 
    <a href="javascript:ToggleAll(false)">select none</a>
    </font>
  </td><td width="33%" align=center>
    <font face="Arial,Helvetica" size=2>
    <?php echo $mailbox_navigation ?>
    </font>
  </td><td width="33%" align=right>
    <font face="Arial,Helvetica" size=2>
    <?php echo "<a href=\"mailbox.php3?action=4&mailbox=$mailbox&server=$server\">empty trash</a>\n" ?>
    </font>
  </td></tr></table>
</td><td bgcolor=ffffff>&nbsp;</td></tr>

<tr><td bgcolor=dcdcdc>&nbsp;</td><td bgcolor=dcdcdc colspan=4>
  <table border=0 width="100%"><tr><td align=left>
    <font face="Arial,Helvetica" size=2>
    <a href="javascript:Submit(0)">[Delete]</a> 
    <a href="javascript:Submit(1)">[Undelete]</a> 
    selected mail
    </font>
  </td>
  
  <form name=transfer2 action="mailbox.php3" method=post>
  
<?php
  $mboxes = imap_listmailbox($mbox, "{$server}", "$folders/*");
  
  $options  = '<option value="">selected mail to:</option>';
  if ($mailbox != 'INBOX') { $options .= '<option value="INBOX">Inbox</option>'; }
  for ($i = 1; $i < count($mboxes); $i++) {
    $label = eregi_replace("{$server}$folders/*", '', $mboxes[$i]);
    if ($mailbox != $mboxes[$i]) { $options .= "<option value=\"$mboxes[$i]\">$label</option>\n"; }
  }
?>
  
  <td align=right>
    <font face="Arial,Helvetica" size=2>
    
    <a href="javascript:Transfer(2, 2)">[Move]</a>
    <a href="javascript:Transfer(3, 2)">[Copy]</a>&nbsp;
    <select name=target>
    <?php echo $options,"\n"; ?>
    </select>
    
    </font>
  </td>
  
  <?php echo "<input type=hidden name=mailbox value=\"$mailbox\">\n"; ?>
  <input type=hidden name=action value="">
  <input type=hidden name=indices value="">
  </form>
  
  </tr></table>
</td></tr>

<?php
  include('templates/generic-footer.inc');
  include('templates/mailbox.php3-javascript.inc');
?>
