<?php

/*
   mysql.lib.php3
   
   IMP v1.5
   Copywrite 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
   
   This code is under the GNU Public License
   See the file COPYING in this directory
*/


/* Settings - these may be different for different backends */

$imp_db        = 'test';                /* the name of imp's db                */
$db_server     = 'localhost';           /* where the database server is        */
$db_user       = 'nobody';              /* user to connect to the database as  */
$db_pass       = '';                    /* database password, if any           */
$pref_table    = 'imp_pref';            /* the name of the prefs table         */
$address_table = 'imp_addr';            /* the name of the address table       */


/* Table Structure for MySQL version:
   
   Preferences Table:
    field:     type:      description:
    user       text       joe@doe.com format username
    sig        text       signature
    (possibly more to be added later)
 
   Address Table:
    field:     type:      description:
    user       text       joe@doe.com identifier of who this entry belongs to
    address    text       address@mail.server.com - the actual address
    nickname   text       any entered nickname - ie "bonnie".
    fullname   text       full name - "My Bonnie".
*/


/* Required Functions - funtions that are called by other files and therefore
 * must be present in all db.lib implementations
 */


function imp_get_signature ($user, $server) {
  global $imp_db, $db_server, $db_user, $pref_table;
  
  /* post: returns the signature for the database key $user@$server
           (a string), or false (0) on failure.
  */
  
  if (!($db = mysql_pconnect($db_server, $db_user))) { return 0; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return 0; }
  if (!($result = mysql_db_query($imp_db, "select sig from $pref_table where user='$user@$server'", $db))) { return 0; }
  
  return(mysql_result($result, 0, 0));
}


function imp_set_signature ($signature, $user, $server) {
  global $imp_db, $db_server, $db_user, $pref_table;
  
  /* post: sets the signature to $signature for the database key $user@$server
           returns true (1) on success and false (0) on failure
  */
  
  if (imp_get_signature($user, $server)) {
    $sql = "update $pref_table set sig='$signature' where user='$user@$server'";
  } else {
    $sql = "insert into $pref_table values ('$user@$server', '$signature')";
  }
  
  if (!($db = mysql_pconnect($db_server, $db_user))) { return 0; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return 0; }
  if (!($result = mysql_db_query($imp_db, $sql, $db))) { return 0; }
  
  return 1;
}


function imp_get_addresses ($user, $server) {
  global $imp_db, $db_server, $db_user, $address_table;
  
  /* post: returns a 2d array of addresses where each
           element is an array in which element 0 is the address,
	   element 1 is the nickname, and element 2 is the fullname.
	   it returns false (0) on failure.
  */
  
  if (!($db = mysql_pconnect($db_server, $db_user))) { return 0; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return 0; }
  if (!($result = mysql_db_query($imp_db, "select address, nickname, fullname from $address_table where user='$user@$server' order by nickname", $db))) { return 0; }
  
  while ($rows = mysql_fetch_row($result)) {
    $return[count($return)] = $rows;
  }
  
  return($return);
}


function imp_delete_address ($address, $user, $server) {
  global $imp_db, $db_server, $db_user, $address_table;
  
  /* post: deletes $address from the addressbook of $user@$server
           returns true (1) on success and false (0) on failure
  */
  
  if (!($db = mysql_pconnect($db_server, $db_user))) { return 0; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return 0; }
  if (!($result = mysql_db_query($imp_db, "delete from $address_table where user='$user@$server' and address='$address'", $db))) { return 0; }
  
  return 1;
}


function imp_add_address ($address, $nickname, $fullname, $user, $server) {
  global $imp_db, $db_server, $db_user, $address_table;
  
  /* post: adds $address, $nickname, $fullname to the addressbook for $user@$server
           returns true (1) on success and false (0) on failure
  */
  
  if (!($db = mysql_pconnect($db_server, $db_user))) { return 0; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return 0; }
  if (!($result = mysql_db_query($imp_db, "insert into $address_table values ('$user@$server', '$address', '$nickname', '$fullname')", $db))) { return 0; }
  
  return 1;
}


function imp_update_address ($old_address, $address, $nickname, $fullname, $user, $server) {
  global $imp_db, $db_server, $db_user, $address_table;
  
  /* post: changes the entry for $old_address to $address, $nickname, $fullname.
           returns true (1) on success and false (0) on failure
  */
  
  if (!($db = mysql_pconnect($db_server, $db_user))) { return 0; }
  if (!($imp = mysql_select_db($imp_db, $db))) { return 0; }
  if (!($result = mysql_db_query($imp_db, "update $address_table set address='$address', nickname='$nickname', fullname='$fullname' where user='$user@$server' and address='$old_address'", $db))) { return 0; }
  
  return 1;
}


/* Support Functions - functions which are only used by routines in this file,
 * and which therefore can change from implementation to implementation.
 */


/* end db.lib */

?>
