<?php

/*
   imp.lib.php3
   
   IMP v1.5
   Copywrite 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
   
   This code is under the GNU Public License
   See the file COPYING in this directory
*/


/* Defaults */

$default_server  = 'wso.williams.edu';      /* default IMAP server to connect to                 */
$default_folders = 'mail/';                 /* default directory to look in for mail folders     */
$default_secure  = 1;                       /* Use SSL for cookies if it is a secure connection  */

$user_change_server = 1;                    /* set false to force use of the default server      */
$user_change_folder = 1;                    /* set false to force use of the default folder dir  */

$imp_root     = '/projects/imp/';           /* base web path to imp files     */
$imp_graphics = '/projects/imp/graphics/';  /* base web path to imp graphics  */

$max_messages_page = 50;                    /* max number of messages to display in one page in mailbox.php3  */

$path_to_db_lib   = 'lib/mysql.lib.php3';
$path_to_sendmail = '/usr/sbin/sendmail';
$path_to_imap     = '/usr/local/apache/libexec/imap.so';


/* Functions */


/* function to wrap text at $wrap, semi-gracefully */

function fill_paragraphs($text, $wrap=80, $break="\n") {
  $lines = explode("\n", $text);
  
  $i = 0;
  
  while ($i < sizeof ($lines)) {
    if (strlen($lines[$i]) < $wrap) {
      $result[count($result)] = $lines[$i];
      $i++;
    } else {
      $result[count($result)] = substr($lines[$i], 0, $wrap);
      $lines[$i] = "+" . substr($lines[$i], $wrap, strlen($lines[$i]) - $wrap);
    }
  }
  return implode($break, $result);
}


/* obtain the -0400 or whatever it is for you offset for the date header */

function gm_offset() {
  $offset = ((date("H") - gmdate("H")));
  if ($offset >= 0) { return sprintf("+%02d", $offset) . "00"; }
  else { return sprintf("-%02d", -$offset) . "00"; }
}


/* make sure the user has a valid login; if so, return an imap stream */

function validate_login($server, $mailbox, $user, $pass) {
  if (! ($mbox = imap_open("{$server}$mailbox", $user, $pass)) ) {
    echo '<script language=javascript>
          <!--
	  document.location="login.php3?reason=timeout";
	  //-->
	  </script>
    ';
  }
  return $mbox;
}


/* function that interfaces to sendmail, so from address and all headers
 * are set correctly
 */

function mailfrom($to, $from, $subject, $hdrs, $message) {
  global $path_to_sendmail;
  
  $mail = popen("$path_to_sendmail -t -f '$to'", "w");
  
  $result  = fputs($mail, "To: $to\n");
  $result += fputs($mail, "From: $from\n");
  $result += fputs($mail, $hdrs);
  $result += fputs($mail, "Subject: $subject\n\n");
  $result += fputs($mail, $message);
  
  pclose($mail);
  
  if ($result > 0) { return 1; }
  else { return 0; }
}


/* cookie setting functions
 * 
 * the strtr in the cookie setting functions is NOT encryption. SSL is
 * relied on for the encryption - if you don't use SSL, NONE of this is
 * secure. this is just in case cookie values get displayed on the screen,
 * or something similar. If someone has a better way, please let me know.
 */

function setuser($user) {
  global $SERVER_PORT;
  
  if ($SERVER_PORT == 443 && $default_secure) { $secure = 1; }
  else { $secure = 0; }
  
  setcookie('chuckmIMPuser', strtr($user, ' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+=-', '1234567890-=ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+abcdefghijklm nopqrstuvwxyz'), "time()+900", $imp_root, '', $secure);
}

function setpass($pass) {
  global $SERVER_PORT;
  
  if ($SERVER_PORT == 443 && $default_secure) { $secure = 1; }
  else { $secure = 0; }
  
  setcookie('chuckmIMPpass', strtr($pass, ' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+=-', '1234567890-=ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+abcdefghijklm nopqrstuvwxyz'), "time()+900", $imp_root, '', $secure);
}

function setsrvr($srvr) {
  global $default_server, $SERVER_PORT;
  
  if ($SERVER_PORT == 443 && $default_secure) { $secure = 1; }
  else { $secure = 0; }
  
  if ($srvr != '') {
    setcookie('chuckmIMPsrvr', strtr($srvr, ' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+=-', '1234567890-=ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+abcdefghijklm nopqrstuvwxyz'), "time()+900", $imp_root, '', $secure);
    return $srvr;
  } else {
    setcookie('chuckmIMPsrvr', strtr($default_server, ' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+=-', '1234567890-=ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+abcdefghijklm nopqrstuvwxyz'), "time()+900", $imp_root, '', $secure);
    return $default_server;
  }
}

function setfldr($fldr) {
  global $default_folders, $SERVER_PORT;
  
  if ($SERVER_PORT == 443 && $default_secure) { $secure = 1; }
  else { $secure = 0; }
  
  if ($fldr != '') {
    setcookie('chuckmIMPfldr', strtr($fldr, ' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+=-', '1234567890-=ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+abcdefghijklm nopqrstuvwxyz'), "time()+900", $imp_root, '', $secure);
    return $fldr;
  } else {
    setcookie('chuckmIMPfldr', strtr($default_folders, ' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+=-', '1234567890-=ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+abcdefghijklm nopqrstuvwxyz'), "time()+900", $imp_root, '', $secure);
    return $default_folders;
  }
}


/* cookie retrieval functions */

function getuser() {
  global $chuckmIMPuser;
  
  return strtr($chuckmIMPuser,'1234567890-=ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+abcdefghijklm nopqrstuvwxyz',' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+=-');
}

function getpass() {
  global $chuckmIMPpass;
  
  return strtr($chuckmIMPpass,'1234567890-=ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+abcdefghijklm nopqrstuvwxyz',' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+=-');
}

function getsrvr() {
  global $chuckmIMPsrvr, $default_server;
  
  if (isset($chuckmIMPsrvr)) {
    return strtr($chuckmIMPsrvr,'1234567890-=ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+abcdefghijklm nopqrstuvwxyz',' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+=-');
  } else {
    return $default_server;
  }
}

function getfldr() {
  global $chuckmIMPfldr, $default_folders;
  
  if (isset($chuckmIMPfldr)) {
    return strtr($chuckmIMPfldr,'1234567890-=ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()_+abcdefghijklm nopqrstuvwxyz',' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+=-');
  } else {
    return $default_folders;
  }
}


/* end imp.lib */

?>
