<?php

/*
   folders.php3
   
   IMP v1.5
   Copywrite 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
   
   This code is under the GNU Public License
   See the file COPYING in this directory
*/
  
  error_reporting(1);            /* surpress imap_stream errors, etc.   */
  require ('lib/imp.lib.php3');  /* IMPlib is the IMP function library  */
  dl($path_to_imap);             /* load the imap module                */
  header('Expires: 120');        /* make the page expire in 2 minutes   */
  
  /* retrieve authentication information from cookies */
  $user    = getuser();
  $pass    = getpass();
  $folders = getfldr();
  $server  = getsrvr();
  $mailbox = '';
  
  /* proceed only with a valid login */
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  
  /* Run through the action handlers */
  if (isset($action)) {
  
    if ( ($action == 'deletefolder') && ($dead_mailbox) ) {
      if (!(imap_deletemailbox($mbox, $dead_mailbox))) {
        $errormsg = '<tr><th colspan=5>An error occured; the folder was not deleted.</th></tr>';
      }
    
    } elseif ( ($action == 'createfolder') && ($new_mailbox) ) {
      $new_mailbox = "{$server}$folders$new_mailbox";
      if (!(imap_createmailbox($mbox, $new_mailbox))) {
        $errormsg = '<tr><th colspan=5>An error occured; the new folder was not created</th></tr>';
      }
    
    } elseif ( ($action == 'renamefolder') && ($old_mailbox) && ($new_mailbox) ) {
      $new_mailbox = "{$server}$folders$new_mailbox";
      if (!(imap_renamemailbox($mbox, $old_mailbox, $new_mailbox))) {
        $errormsg = '<tr><th colspan=5>An error occured; the folder was not renamed</th></tr>';
      }
    }
  }
  
  /* close and reopen the imap stream so the mailbox list is up to date */
  imap_close($mbox);
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  $title = "Mail Folders";
  include('templates/generic-header_reload.inc');
  
  $mboxes = imap_listmailbox($mbox, "{$server}", "$folders/*");
  
  $options = '';
  for ($i = 1; $i < count($mboxes); $i++) {
    $label = eregi_replace("{$server}$folders/*", '', $mboxes[$i]);
    $options .= "<option value=\"$mboxes[$i]\">$label</option>\n";
  }
  
  include('templates/folders.php3-delete.inc');
  include('templates/folders.php3-rename.inc');
  include('templates/folders.php3-create.inc');
  include('templates/generic-footer.inc');
?>
