<?php

/*
   compose.php3
   
   IMP v1.5
   Copywrite 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
   
   This code is under the GNU Public License
   See the file COPYING in this directory
*/
  
  error_reporting(1);            /* surpress imap_stream errors, etc.   */
  require ('lib/imp.lib.php3');  /* IMPlib is the IMP function library  */
  require ($path_to_db_lib);     /* DBlib is the db backend library     */
  dl($path_to_imap);             /* load the imap module                */
  header('Expires: 120');        /* make the page expire in 2 minutes   */
  
  $user    = getuser();
  $pass    = getpass();
  $folders = getfldr();
  $server  = getsrvr();
  if (!isset($mailbox)) { $mailbox = 'INBOX'; }
  
  /* make the user login so people can't fake email quite so easily */
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  /* Run through action handlers */
  
  /* Actions
     0 - new message
     1 - reply
     2 - reply to all
     3 - forward
  */
  
  if (isset($action)) {
    switch ($action) {
      case 0:
        break;
      
      case 1:
	if ($mailbox && $index && $bodypart) {
	  $h = imap_header($mbox, $index);
	  if ($h->reply_toaddress) { $to = chop(htmlentities($h->reply_toaddress)); }
	  else { $to = chop(htmlentities($h->fromaddress )); }
	  
	  $msg  = "Quoting $to:\n\n&gt; ";
	  $msg .= htmlentities(fill_paragraphs(imap_fetchbody($mbox, $index, $bodypart), 75, "\n> "));
	  $msg .= "\n";
	  
	  $subject = 'Re: ' . chop(htmlentities($h->subject));
	}
	break;
      
      case 2:
        if ($mailbox && $index && $bodypart) {
	  $h = imap_header($mbox, $index);
	  if ($h->reply_toaddress) { $reply = chop(htmlentities($h->reply_toaddress)); }
	  else { $reply = chop(htmlentities($h->fromaddress )); }
	  
	  /* build up the reply to all addresses */
	  if ($reply != chop(htmlentities($h->fromaddress ))) { $to = $reply . ',' . chop(htmlentities($h->fromaddress )); }
	  else { $to = $reply; }
	  if ( $reply != chop(htmlentities($h->toaddress )) ) { $to .= "," . chop(htmlentities($h->toaddress )); }
	  if ( $h->ccaddress) { $to .= ',' . chop(htmlentities($h->ccaddress )); }
	  
	  $msg  = "Quoting $reply:\n\n&gt; ";
	  $msg .= htmlentities(fill_paragraphs(imap_fetchbody($mbox, $index, $bodypart), 75, "\n> "));
	  $msg .= "\n";
	  
	  $subject = 'Re: ' . chop(htmlentities($h->subject));
	}
	break;
      
      case 3:
        if ($mailbox && $index && $bodypart) {
	  $h = imap_header($mbox, $index);
	  if ($h->reply_toaddress) { $to = chop(htmlentities($h->reply_toaddress)); }
	  else { $to = chop(htmlentities($h->fromaddress )); }
	  
	  $msg  = "\n----- Forwarded message from $to -----\n";
	  
	  if ($h->date) { $msg .= 'Date: ' . chop(htmlentities($h->date)) . "\n"; }
	  if ($h->fromaddress) { $msg .= 'From: ' . chop(htmlentities($h->fromaddress)) . "\n"; }
	  if ($h->reply_toaddress) { $msg .= 'Reply-To: ' . chop(htmlentities($h->reply_toaddress)) . "\n"; }
	  if ($h->subject) { $msg .= 'Subject: ' . chop(htmlentities($h->subject)) . "\n"; }
	  if ($h->toaddress) { $msg .= 'To: ' . chop(htmlentities($h->toaddress)) . "\n"; }
	  $msg .= "\n";
	  $msg .= htmlentities(fill_paragraphs(imap_fetchbody($mbox, $index, $bodypart)));
	  $msg .= "\n----- End forwarded message -----\n";
	  
	  $subject = 'Fwd: ' . chop(htmlentities($h->subject));
	}
	break;
    }
  }
  
  
  $title = "Compose a message";
  include('templates/generic-header.inc');
  
  $msg .= "\n\n\n" . imp_get_signature($user, $server);
  
  $addresses = imp_get_addresses($user, $server);
  
  $options = '<option value=\'\'>add address:</option>';
  for ($i = 0; $i < count($addresses); $i++) {
    $options .= '<option value="' . $addresses[$i][0] . '">' . $addresses[$i][1] . ' &lt;' . $addresses[$i][0] . "&gt;\n";
  }
  
  include('templates/compose.php3-compose.inc');
  include('templates/generic-footer.inc');
  include('templates/compose.php3-javascript.inc');
?>
