<?php

/*
   addressbook.php3
   
   IMP v1.5
   Copywrite 1998 Charles J. Hagenbuch <chuck@osmos.ml.org>
   
   This code is under the GNU Public License
   See the file COPYING in this directory
*/
  
  error_reporting(1);            /* surpress imap_stream errors, etc.   */
  require ('lib/imp.lib.php3');  /* IMPlib is the IMP function library  */
  require ($path_to_db_lib);     /* DBlib is the db backend library     */
  dl($path_to_imap);             /* load the imap module                */
  header('Expires: 120');        /* make the page expire in 2 minutes   */
  
  /* retrieve authentication information from cookies */
  $user    = getuser();
  $pass    = getpass();
  $folders = getfldr();
  $server  = getsrvr();
  $mailbox = '';
  
  /* proceed only with a valid login */
  $mbox = validate_login($server, $mailbox, $user, $pass);
  
  
  /* Actions
      0 - nothing
      1 - delete entry
      2 - add entry
      3 - change entry
  */
  
  /* Run through the action handlers */
  if (isset($action)) {
    switch($action) {
      case 0:
        break;
      
      case 1:
        if ($dead_address) {
	  if (!(imp_delete_address($dead_address, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; the entry was not deleted from your addressbook.</th></tr>';
	  }
	}
	break;
      
      case 2:
        if ($new_address && $new_nickname && $new_fullname) {
	  if (!(imp_add_address($new_address, $new_nickname, $new_fullname, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; the entry was not created.</th></tr>';
	  }
	}
	break;
      
      case 3:
        if ($old_address && $new_address && $new_nickname && $new_fullname) {
	  if (!(imp_update_address($old_address, $new_address, $new_nickname, $new_fullname, $user, $server))) {
	    $errormsg = '<tr><th>An error occured; the entry was not changed.</th></tr>';
	  }
	}
	break;
    }
  }
  
  
  $title = "Addressbook";
  include('templates/generic-header.inc');
  
  $addresses = imp_get_addresses($user, $server);
  
  for ($i = 0; $i < count($addresses); $i++) {
    $options .= '<option value="' . $addresses[$i][0] . '">' . $addresses[$i][1] . ' &lt;' . $addresses[$i][0] . "&gt;\n";
  }
?>

<form action="addressbook.php3" method=post name="add">
<input type=hidden name=action value="2">
Address: <input name="new_address"><br>
Nickname: <input name="new_nickname"><br>
Fullname: <input name="new_fullname"><br>
<input type=submit value=" add address ">
</form>

<hr>

<form action="addressbook.php3" method=post name="update">
<input type=hidden name=action value="3">
<select name="old_address" onchange="setFields()">
<?php echo $options ?>
</select><br>
New Address: <input name="new_address" value="<?php echo $addresses[0][0] ?>"><br>
New Nickname: <input name="new_nickname" value="<?php echo $addresses[0][1] ?>"><br>
New Fullname: <input name="new_fullname" value="<?php echo $addresses[0][2] ?>"><br>
<input type=submit value=" change address ">
</form>

<hr>

<form action="addressbook.php3" method=post name="delete">
<input type=hidden name=action value="1">
<select name="dead_address">
<?php echo $options ?>
</select><br>
<input type=submit value=" delete this address ">
</form>

<?php
  include('templates/generic-footer.inc');
  include('templates/addressbook.php3-javascript.inc');
?>
