<?php
/**
 * Highlights simple markup as used in emails or usenet postings.
 *
 * $Horde: framework/Text_Filter/Filter/simplemarkup.php,v 1.1 2004/10/05 11:50:13 jan Exp $
 *
 * Copyright 2004 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you did
 * not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Jan Schneider <jan@horde.org>
 * @version $Revision: 1.1 $
 * @since   Horde 3.0
 * @package Horde_Text
 */
class Text_Filter_simplemarkup extends Text_Filter {

    /**
     * Returns a hash with replace patterns.
     *
     * @return array  Patterns hash.
     */
    function getPatterns()
    {
        $regexp = array(
            // bold
            '/(\s|\n)(\*[^*\s]+\*)(\s|\r|\n|<br)/i' => '\1<b>\2</b>\3',

            // underline
            '/(\s|\n)(_[^_\s]+_)(\s|\r|\n|<br)/i' => '\1<u>\2</u>\3',

            // italic
            ';(\s|\n)(/[^/\s]+/)(\s|\r|\n|<br);i' => '\1<i>\2</i>\3');

        return array('regexp' => $regexp);
    }

}