<?php

require_once 'Horde/Text/Filter.php';
require_once 'Text/reST.php';
require_once 'Text/reST/Formatter.php';

/**
 * The Text_Filter_rst:: class converts reStructuredText to HTML.
 *
 * $Horde: framework/Text_Filter/Filter/rst.php,v 1.9 2004/10/06 01:57:34 chuck Exp $
 *
 * Copyright 2003-2004 Jason M. Felice <jfelice@cronosys.com>
 *
 * See the enclosed file COPYING for license information (LGPL). If you did not
 * receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Jason M. Felice <jfelice@cronosys.com>
 * @version $Revision: 1.9 $
 * @package Horde_Text
 */
class Text_Filter_rst extends Text_Filter {

    /**
     * Executes any code necessaray after applying the filter
     * patterns.
     *
     * @param string $text  The text after the filtering.
     *
     * @return string  The modified text.
     */
    function postProcess($text)
    {
        $document = &Text_reST::parse($text);
        $formatter = &Text_reST_Formatter::factory('html');
        return $formatter->format($document, NLS::getCharset());
    }

}
