<?php
/**
 * The MIME_Viewer_images class allows images to be displayed.
 *
 * $Horde: framework/MIME/MIME/Viewer/images.php,v 1.18 2004/11/04 15:51:08 jan Exp $
 *
 * Copyright 2002-2004 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
 * @version $Revision: 1.18 $
 * @since   Horde 2.2
 * @package Horde_MIME_Viewer
 */
class MIME_Viewer_images extends MIME_Viewer {

    /**
     * Render out the currently set contents.
     * The $mime_part class variable has the information to render
     * out, encapsulated in a MIME_Part object.
     */
    function render()
    {
        global $browser;

        if ($browser->isViewable($this->getType())) {
            return $this->mime_part->getContents();
        }
    }

    /**
     * Return the content-type.
     *
     * @access public
     *
     * @return string  The content-type of the output.
     */
    function getType()
    {
        global $browser;

        $type = $this->mime_part->getType();
        if ($browser->isBrowser('mozilla') && ($type == 'image/pjpeg')) {
            /* image/jpeg and image/pjpeg *appear* to be the same
             * entity, but Mozilla don't seem to want to accept the
             * latter.  For our purposes, we will treat them the
             * same. */
            return 'image/jpeg';
        } elseif ($type == 'image/x-png') {
            /* image/x-png is equivalent to image/png. */
            return 'image/png';
        } else {
            return $type;
        }
    }

    /**
     * Generate HTML output for a javascript auto-resize view window.
     *
     * @access private
     *
     * @param string $url    The URL which contains the actual image data.
     * @param string $title  The title to use for the page.
     *
     * @return string  The HTML output.
     */
    function _popupImageWindow($url, $title)
    {
        global $browser;

        $str = <<<EOD
<html>
<head>
<title>$title</title>
<style type="text/css"><!-- body { overflow:hidden; margin:0px; padding:0px; } --></style>
EOD;

        /* Only use javascript if we are using a DOM capable browser. */
        if ($browser->getFeature('dom')) {
            /* Translate '&amp' entities to '&' for JS URL links. */
            $url = str_replace('&amp;', '&', $url);

            /* Javascript display. */
            $loading = _("Loading...");
            $str .= <<<EOD
<script language="javascript" type="text/javascript">
function resizeWindow() {
    window.moveTo(0, 0);
    var img = new Image();
    img.onload = function() { sizeImgWin(img); };
    img.src = "$url";
}

function sizeImgWin(img) {
    var new_w = img.width;
    var new_h = img.height;
    var old_w = window.innerWidth || window.document.body.offsetWidth;
    var old_h = window.innerHeight || window.document.body.offsetHeight;

    if (!new_w) { new_w = old_w; }
    if (!new_h) { new_h = old_h; }

    new_w -= old_w;
    new_h -= old_h;

    window.resizeBy(new_w, new_h);
    document.getElementById('splash').style.display = 'none';
    var pic = document.getElementById('disp_image');
    pic.src = img.src;
    pic.style.display = 'block';
}
</script></head>
<body onload="resizeWindow();"><span id="splash" style="color:gray;font-family:sans-serif;padding:2px;">$loading</span><img id="disp_image" style="display:none;" /></body></html>
EOD;
        } else {
            /* Non-javascript display. */
            $img_txt = _("Image");
            $str .= <<<EOD
</head>
<body bgcolor="#ffffff" topmargin="0" marginheight="0" leftmargin="0" marginwidth="0">
<img border="0" src="$url" alt="$img_txt" />
</body>
</html>
EOD;
        }

        return $str;
    }

}
