<?php

require_once dirname(__FILE__) . '/imc.php';
require_once 'Horde/iCalendar.php';

/**
 * Implement the Horde_Data:: API for vCard data.
 *
 * $Horde: framework/Data/Data/vcard.php,v 1.33 2004/08/18 03:16:23 chuck Exp $
 *
 * Copyright 1999-2004 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Jan Schneider <jan@horde.org>
 * @version $Horde: framework/Data/Data/vcard.php,v 1.33 2004/08/18 03:16:23 chuck Exp $
 * @since   Horde 3.0
 * @package Horde_Data
 */
class Horde_Data_vcard extends Horde_Data_imc {

    /**
     * Exports vcalendar data as a string. Unlike vEvent, vCard data
     * is not enclosed in BEGIN|END:vCalendar.
     *
     * @access public
     *
     * @param array  $data   An array containing Horde_iCalendar_vcard objects.
     * @param string $method (optional) The iTip method to use.
     *
     * @return string  The iCalendar data.
     */
    function exportData($data, $method = 'REQUEST')
    {
        global $prefs;

        $this->_iCal = &new Horde_iCalendar();

        $this->_iCal->setAttribute('METHOD', $method);
        $s = '';
        foreach ($data as $event) {
            $s.= $event->exportvCalendar();
        }
        return $s;
    }

}
