<?php

require_once 'Horde/Auth/imap.php';

/**
 * Kolab implementation of the Horde authentication system. Derives from the
 * Auth_imap IMAP authentication object, and simply provides parameters to it
 * based on the global Kolab configuration.
 *
 * $Horde: framework/Auth/Auth/kolab.php,v 1.1 2004/08/30 16:08:23 stuart Exp $
 *
 * Copyright 2004 Stuart Binge <s.binge@codefusion.co.za>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Stuart Binge <s.binge@codefusion.co.za>
 * @version $Revision: 1.1 $
 * @since   Horde 1.3
 * @package Horde_Auth
 */
class Auth_kolab extends Auth_imap {

    /**
     * Constructs a new Kolab authentication object.
     *
     * @access public
     *
     * @param optional array $params  A hash containing connection parameters.
     */
    function Auth_kolab($params = array())
    {
        $params['hostspec'] = $GLOBALS['conf']['kolab']['imap']['server'];
        $params['port'] = $GLOBALS['conf']['kolab']['imap']['port'];
        $params['protocol'] = 'imap/notls/novalidate-cert';

        parent::Auth_imap($params);
    }

}
