<?php

require_once dirname(__FILE__) . '/Widget.php';

/**
 * The Horde_UI_Tabs:: class manages and renders a tab-like interface.
 *
 * $Horde: framework/UI/UI/Tabs.php,v 1.27.6.1 2005/01/03 12:19:19 jan Exp $
 *
 * Copyright 2001-2003 Robert E. Coyle <robertecoyle@hotmail.com>
 * Copyright 2003-2005 Jason M. Felice <jfelice@cronosys.com>
 *
 * See the enclosed file LICENSE for license information (LGPL).
 *
 * @version $Revision: 1.27.6.1 $
 * @since   Horde_UI 0.0.1
 * @package Horde_UI
 */
class Horde_UI_Tabs extends Horde_UI_Widget {

    /**
     * The array of tabs.
     * @var array $_tabs
     */
    var $_tabs = array();

    /**
     * Add a tab to the interface.
     *
     * @access public
     *
     * @param string $title    The text which appears on the tab.
     * @param string $link     The target page.
     * @param string $tabname  The value to set the tab variable to.
     */
    function addTab($title, $link, $tabname = null)
    {
        $this->_tabs[] = array('title' => $title, 'link' => $link, 'tabname' => $tabname);
    }

    /**
     * Retreive the title of the tab with the specified name.
     *
     * @access public
     *
     * @param string $tabname  The name of the tab.
     *
     * @return string  The tab's title.
     */
    function getTitleFromAction($tabname)
    {
        foreach ($this->_tabs as $tab) {
            if ($tab['tabname'] == $tabname) {
                return $tab['title'];
            }
        }

        return null;
    }

    /**
     * Renders the tabs.
     *
     * @param string $active_tab  If specified, the name of the active tab. If
     *                            not, the active tab is determined
     *                            automatically.
     */
    function render($active_tab = null)
    {
        $html = "<ul class='tabset'>\n";

        $first = true;
        $active = $_SERVER['PHP_SELF'] . $this->_vars->get($this->_name);

        foreach ($this->_tabs as $tab) {
            $link = $this->_addPreserved($tab['link']);
            if (!is_null($this->_name) && !is_null($tab['tabname'])) {
                $link = Util::addParameter($link, $this->_name,
                                           $tab['tabname']);
            }

            $class = null;
            if ((!is_null($active_tab) && $active_tab == $tab['tabname']) ||
                ($active == $tab['link'] . $tab['tabname'])) {
                $class = 'activeTab';
            }

            $accesskey = Horde::getAccessKey($tab['title']);

            $html .= '<li>' .
                Horde::link($link, $tab['title'], $class, null, null, null, $accesskey) .
                str_replace(' ', '&nbsp;', Horde::highlightAccessKey($tab['title'], $accesskey)) .
                "</a> </li>\n";
        }

        return $html . "</ul>\n";
    }

}
