# $Horde: horde/scripts/db/mysql_create.sql,v 1.1.2.4 2001/12/29 20:25:28 rich Exp $
#
# If you are installing Horde for the first time, you can simply 
# direct this file to mysql as STDIN:
#
# $ mysql --user=root --password=<MySQL-root-password> < mysql_create.sql
# 
# If you are upgrading from a previous version, you will need to comment
# out the the user creation steps below, as well as the schemas for any
# tables that already exist.
#
# If you are upgrading from Horde 1.x, the Horde tables you have from
# that version are no longer used; you may wish to either delete those
# tables or simply recreate the database anew.

CONNECT mysql;

REPLACE INTO user (host, user, password)
    VALUES (
        'localhost',
        'horde',
  -- IMPORTANT: Change this password!
        password('horde')
    );

REPLACE INTO db (host, db, user, select_priv, insert_priv, update_priv,
                 delete_priv, create_priv, drop_priv)
    VALUES (
        'localhost',
        'horde',
        'horde',
        'Y', 'Y', 'Y', 'Y',
        'Y', 'Y'
    );

# MySQL 3.23.x appears to have "CREATE DATABASE IF NOT EXISTS" and
# "CREATE TABLE IF NOT EXISTS" which would be a nice way to handle
# reinstalls gracefully (someday).  For now, use mysql_drop.sql first
# to avoid CREATE errors.

CREATE DATABASE horde;

CONNECT horde;

CREATE TABLE horde_users (
    user_uid       varchar(255) not null,
    user_pass      varchar(32) not null,
    primary key (user_uid)
);

GRANT SELECT, INSERT, UPDATE, DELETE ON horde_users TO horde;

CREATE TABLE horde_prefs (
    pref_uid        char(255) not null,
    pref_scope      char(16) not null default '',
    pref_name       char(32) not null,
    pref_value      text null,
    primary key (pref_uid, pref_scope, pref_name)
);

GRANT SELECT, INSERT, UPDATE, DELETE ON horde_prefs TO horde;

CREATE TABLE horde_categories (
       category_id INT not null,
       group_uid VARCHAR(255) not null,
       user_uid VARCHAR(255),
       category_name VARCHAR(255) not null,
       category_data TEXT null,
       category_serialized SMALLINT DEFAULT 0 not null,
       category_updated TIMESTAMP,
       PRIMARY KEY (category_id)
);

CREATE INDEX category_category_name_idx ON horde_categories (category_name);
CREATE INDEX category_group_idx ON horde_categories (group_uid);
CREATE INDEX category_user_idx ON horde_categories (user_uid);
CREATE INDEX category_serialized_idx ON horde_categories (category_serialized);

CREATE TABLE horde_categories_categories (
       category_id_parent INT not null,
       category_id_child INT not null,
       PRIMARY KEY (category_id_parent, category_id_child)
);

GRANT SELECT, INSERT, UPDATE, DELETE ON horde_categories TO horde;
GRANT SELECT, INSERT, UPDATE, DELETE ON horde_categories_categories TO horde;

FLUSH PRIVILEGES;

# Done!
