<?php
/*
 * $Horde: horde/menu.php,v 2.14.2.6 2002/01/02 17:05:10 jan Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__));
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Menu.php';

/* Define target */
$opener = false;
if ($conf['menu']['floating_bar'] && (!$browser->hasQuirk('avoid_popup_windows'))) {
    $opener = true;
    $title = _("Horde System");
}

require $registry->getTemplatePath("horde") . '/common-header.inc';

/* Build the menu out of the modules array */
$moduletext = '';

/*
 * Now print a link for each module (no links are fine since there
 * will be other stuff here)
 */
foreach ($registry->applications as $service => $params) {
    if ($params['show']) {
        if (!$opener) {
            $moduletext .= Menu::createItem(Horde::url($params['webroot'] . '/' . (isset($params['initial_page']) ? $params['initial_page'] : '')),
                                            $params['name'], $params['icon'], '', 'horde_main');
        } else {
            $moduletext .= Menu::createItem('', $params['name'], $params['icon'],
                                            '', 'horde_main',
                                            'window.opener.location.href=\'' . Horde::url($params['webroot']) . '\'; return false;');
        }
    }
}

/* Add the administration link if the user is an admin. */
if (in_array(Auth::getAuth(), $conf['auth']['admins'])) {
    if (!$opener) {
        $moduletext .= Menu::createItem(Horde::applicationUrl('admin/'), _("Administration"),
                                        'administration.gif', null, 'horde_main');
    } else {
        $moduletext .= Menu::createItem('', _("Administration"), 'administration.gif', null, 'horde_main',
                                        'window.opener.location.href=\'' . Horde::applicationUrl('admin/') . '\'; return false;');
    }
}

/* Add a logout link */
$moduletext .= Menu::createItem(Horde::applicationUrl('login.php?reason=logout'), _("Log out"), 'logout.gif', null, 'horde_main');

require $registry->getTemplatePath("horde") . '/horde/modules.inc';
require $registry->getTemplatePath("horde") . '/common-footer.inc';

?>
