<?php
// $Horde: horde/lib/base.php,v 1.3.2.1 2001/11/10 00:02:53 chuck Exp $

/*
 * Horde base inclusion file.
 *
 * This file brings in all of the dependencies that Horde framework-level
 * scripts will need, and sets up objects that all scripts use.
 *
 * NB: this base file does _not_ check authentication, so as to avoid
 * an infinite loop on the Horde login page. You'll need to do it
 * yourself in framework-level pages.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/..');

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('horde');
$conf = &$GLOBALS['conf'];

// set error reporting according to config settings
error_reporting($conf['debug_level']);

// set max execution time according to config settings
set_time_limit($conf['max_exec_time']);

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Browser.php';

// Browser detection object
$browser = new Browser();

?>
