<?php
// $Horde: horde/lib/MIME/Magic.php,v 1.3.2.2 2001/12/15 22:59:55 chuck Exp $

/**
 * The MIME_Magic:: class provides an interface to determine a
 * MIME type for various content, if it provided with different
 * levels of information.
 *
 * Currently, it can map a file extension to a MIME type, but
 * future ideas include using Apache's mod_mime_magic (if available),
 *
 * @author  Anil Madhavapeddy <anil@recoil.org>
 * @version $Revision: 1.3.2.2 $
 * @since   Horde 1.3
 * @package horde.mime
 */

class MIME_Magic {

    /**
     * Attempt to convert a file extension to a MIME type, based
     * on the global Horde and application specific config files.
     *
     * If we cannot map the file extension to a specific type, then 
     * we fall back to a custom MIME handler x-extension/type, which
     * can be used as a normal MIME type internally throughout Horde.
     *
     * @param string $ext The file extension to be mapped to a MIME type
     * @return string The MIME type of the file extension
     */
    function extToMIME($ext)
    {
        global $mime_extension_map;

        if (empty($ext)) {
           return 'text/plain';
        } else if (!isset($mime_extension_map[$ext])) {
            return "x-extension/$ext";
        } else {
            return $mime_extension_map[$ext];
        }
    }

}
?>
