<?php
/*
 * $Horde: horde/index.php,v 2.43.2.3 2002/01/02 17:05:07 jan Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__));

$horde_configured = (@file_exists('./config/horde.php') &&
                     @file_exists('./config/html.php') &&
                     @file_exists('./config/mime_drivers.php') &&
                     @file_exists('./config/mime_mapping.php') &&
                     @file_exists('./config/registry.php'));

if ($horde_configured) {
    require_once './lib/Registry.php';
    $registry = &Registry::singleton();

    include_once './lib/base.php';
    include_once './lib/Secret.php';

    /* Initialize the Auth credentials key. */
    Secret::setKey('auth');

    if ($browser->hasFeature('wml')) {
        include $registry->getTemplatePath('horde') . '/index/wap.inc';
    } elseif ($conf['menu']['floating_bar'] && (!$browser->hasQuirk('avoid_popup_windows'))) {
        $flmenu_width = count($registry->applications) * 50;
        include $registry->getTemplatePath('horde') . '/index/floating_index.inc';
    } else {
        if ($browser->hasQuirk('scrollbar_in_way')) {
            $scrollbar = 'yes';
        } else {
            $scrollbar = 'auto';
        }
        include $registry->getTemplatePath('horde') . '/index/frames_index.inc';
    }
} else {
    include './templates/index/notconfigured.inc';
}

?>
