<?php
/*
 * $Horde: horde/test.php,v 1.26 2000/12/18 20:34:02 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999, 2000 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

session_start();
/* Register a session. */
if (!isset($horde_test_count)) {
    $horde_test_count = 0;
    session_register('horde_test_count');
}

/* We want to be as verbose as possible here. */
error_reporting(E_ALL);

function status($foo) {
    if ($foo) {
        echo '<font color="green"><b>Yes</b></font>';
    } else {
        echo '<font color="red"><b>No</b></font>';
    }
}

/* Horde versions */
$versions = array();
require_once './lib/version.php';
$versions['horde'] = HORDE_VERSION;

$modules = array('imp', 'turba', 'kronolith', 'jonah', 'whups', 'nic', 'babel');
foreach ($modules as $module) {
    if (@is_readable("./$module/lib/version.php")) {
        include "./$module/lib/version.php";
        eval('$ver = ' . strtoupper($module) . '_VERSION;');
        $versions[$module] = $ver;
    }
}

/* PHP Version */
$version = phpversion();
$major = $version[0];
$pl = strstr($version, "pl");
if ($pl) {
    $version = substr_replace($version, '', -strlen($pl));
}
if (strspn($version, '0123456789.') == strlen($version)) {
    $bits = explode('.', $version);
    $minor = $bits[count($bits) - 1];
    $class = 'release';
} else {
    $tail = substr($version, -4);
    if (($tail == '-dev') || ($tail == '-cvs')) {
        $bits = explode('.', $version);
        $minor = $bits[count($bits) - 1];
        $minor = substr($minor, 0, strlen($minor) - 4);
        $class = substr($tail, 1);
    } else {
        $minor = substr($version, 3);
        $class = 'beta';
    }
}

/* PHP module capabilities */
$ftp = extension_loaded('ftp');
$gettext = extension_loaded('gettext');
$imap = extension_loaded('imap');
$ldap = extension_loaded('ldap');
$mcal = extension_loaded('mcal');
$mcrypt = extension_loaded('mcrypt');
$mysql = extension_loaded('mysql');
$pgsql = extension_loaded('pgsql');
$xml = extension_loaded('xml');

/* PHP Settings */
$magic_quotes_gpc = !get_magic_quotes_gpc();
$magic_quotes_runtime = !get_magic_quotes_runtime();

/* Handle special modes */
if (isset($HTTP_GET_VARS['mode'])) {
    switch ($HTTP_GET_VARS['mode']) {
    case 'phpinfo':
        phpinfo();
        exit;
        break;

    case 'unregister':
        session_unregister("horde_test_count");
        ?>
        <html>
        <body bgcolor="white" text="black">
        <font face="Helvetica, Arial, sans-serif" size="2">
        The test session has been unregistered.<br>
        <a href="test.php">Go back</a> to the test.php page.<br>
        <?php
        exit;
        break;

    default:
        break;
    }
} else {
?>

<html>
<head>
<title>Horde: System Capabilities Test</title>
</head>

<body bgcolor="#ffffff" text="#000000">

<font face="Helvetica, Arial, sans-serif" size="2">
<a href="test.php?mode=phpinfo">View phpinfo() screen</a>

<h3>Horde Versions</h3>
<ul>
<?php
while (list($module, $ver) = each($versions)) {
    $module = ucfirst($module);
    if ($module == 'Imp')
        $module = 'IMP';
    echo "<li>$module: $ver</li>\n";
}
?>
</ul>

<h3>PHP Version</h3>
<ul>
    <li>PHP Version: <?php echo "$version$pl"; ?></li>
    <li>PHP Major Version: <?php echo $major; ?></li>
    <li>PHP Minor Version: <?php echo "$minor$pl"; ?></li>
    <li>PHP Version Classification: <?php echo $class; ?></li>
    <?php if ($major == 3) { ?>
        <li><font color="red">You need to upgrade to PHP4. PHP3 will not work.</font></li>
    <?php } elseif ($major == 4) {
        if ($class == 'beta') { ?>
            <li><font color="red">You are running a beta or release candidate of PHP4. You need to upgrade to a release version, at least 4.0.3.</font></li>
        <?php } elseif ($minor < 3) { ?>
            <li><font color="red">You are running a version of PHP4 older than 4.0.3. You need to upgrade to at least 4.0.3.</font></li>
        <?php } else { ?>
            <li><font color="green">You are running a supported release of PHP4. Enjoy the ride!</font></li>
        <?php } ?>
    <?php } else { ?>
        <li><font color="orange">Wow, a mystical PHP from the future. Let <a href="mailto:dev@lists.horde.org">dev@lists.horde.org</a> know what version you have so we can fix this script.</font></li>
    <?php } ?>
</ul>

<h3>PHP Module Capabilities</h3>
<ul>
    <li>FTP Support: <?php status($ftp); ?></li>
    <li>Gettext Support: <?php status($gettext); ?></li>
    <li>IMAP Support: <?php status($imap) ?></li>
    <li>LDAP Support: <?php status($ldap); ?></li>
    <li>MCAL Support: <?php status($mcal); ?></li>
    <li>Mcrypt Support: <?php status($mcrypt); ?></li>
    <li>MySQL Support: <?php status($mysql); ?></li>
    <li>PostgreSQL Support: <?php status($pgsql); ?></li>
    <li>XML Support: <?php status($xml); ?></li>
</ul>

<h3>Miscellaneous PHP Settings</h3>
<ul>
    <li>magic_quotes_gpc set to Off: <?php echo status($magic_quotes_gpc); ?></li>
    <?php if (!$magic_quotes_gpc) { ?>
    <li><font color="red">magic_quotes_gpc causes data coming from GET, POST, or COOKIE modes to be processed so that single quotes and backslashes are prefixed with a backslash (\'). This makes your email look very ugly. Turn it off.</font></li>
    <?php } ?>
    <li>magic_quotes_runtime set to Off: <?php echo status($magic_quotes_runtime); ?></li>
    <?php if (!$magic_quotes_runtime) { ?>
    <li><font color="red">magic_quotes_runtime may not cause quite as many problems as magic_quotes_gpc, but you still do not need it. Turn it off.</font></li>
    <?php } ?>
</ul>

<h3>PHP Sessions</h3>
<?php $horde_test_count++; ?>
<ul>
    <li>Session counter: <?php echo $horde_test_count; ?></li>
    <li>To unregister the session: <A HREF="test.php?mode=unregister">click here</A>
</ul>

</font>

<?php } ?>

</body>
</html>
