#!/bin/sh
#
#  $Horde: horde/scripts/horde-rsync.sh,v 2.8 2000/06/17 11:31:55 jon Exp $
#
#  This script performs a checkout from the horde CVS tree at horde.org
#
#  [ Edit the following values to suit your local environment ]

# The path to your CVSROOT:
export CVSROOT="/home/username/rync/RSYNC"

# The path in which to put the retrieved Horde files:
export HORDE_DIR="/home/username/rsync/horde"

# The absolute path to your rsync binary:
export RSYNC="/usr/bin/rsync"

# The absolute path to your cvs binary:
export CVSCOMMAND="/usr/bin/cvs"

# The modules which you'd like to retrieve:
export MODULE_LIST="imp kronolith turba jonah babel"
export COMMA_MODULES="imp,kronolith,turba,jonah,babel"


#  -[ NOTHING ELSE SHOULD NEED TO BE EDITED BELOW THIS LINE ]-

MYNAME=`basename $0`

# Test the commandline arguments
if [ $# -lt 3 ] ; then
    echo "Usage: $MYNAME --with-modules=[module[, module]*] --type=[checkout|update] --label=[\"\"|[label]]" 1>&2
    exit 2
fi

if (echo "$2" | grep -c "checkout" -) then
    export CVS_ARGS="-q checkout"
    export CVS_ACTION="Checking out"
else
    export CVS_ARGS="-q update"
    export CVS_ACTION="Updating"
fi

if (echo "$3" | grep -c "STABLE" -) then
    export LABEL="STABLE"
else
    export LABEL="HEAD"
fi

export CWD=`pwd`
export RSYNC_ARGS="-az --delete"
export RSYNC_DIR="rsync.horde.org::horde-cvs/"

# Sync up our repository with the main repository

echo
echo "***************************"
echo "Rsyncing with $RSYNC_DIR..."
echo "***************************"
echo

$RSYNC $RSYNC_ARGS $RSYNC_DIR $CVSROOT

# Checkout the main Horde module
cd `dirname $HORDE_DIR`

echo
echo "*********************************"
echo "$CVS_ACTION main Horde module..."
echo "*********************************"
echo

$CVSCOMMAND $CVS_ARGS -r $LABEL horde
cd $HORDE_DIR

# Check out each of the other modules specified
for MODULE in $MODULE_LIST; do
    if (echo "$1" | grep -c "$MODULE" - ) then

	echo 
	echo "*****************************"
      	echo "$CVS_ACTION $MODULE..."
	echo "*****************************";
	echo
	
	$CVSCOMMAND $CVS_ARGS -r $LABEL $MODULE
    fi
done

# Put the user back where they came from
cd $CWD
