<?php
/*
 * $Horde: horde/problem.php,v 2.53 2001/01/10 19:24:19 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999, 2000 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

/* Send the browser back to the correct page. */
function returnToPage() {
    $returnURL = Horde::getFormData('return_url', 'login.php');
    header('Location: ' . $returnURL);
}

require './config/horde.php';
error_reporting($horde['debug_level']);

require_once './lib/Horde.php';
require_once './lib/version.php';
require_once './lib/Browser.php';
$browser = new Browser();

require './config/mime.php';

bindtextdomain('horde', './locale');
textdomain('horde');

session_name($horde['session_name']);
@session_start();

/* Array to translate string actions into the appropriate integer ID. */
$actions[_("Send Problem Report")] = HORDE_SEND_MESSAGE;
$actions[_("Cancel Problem Report")] = HORDE_NO_ACTION;

$name = Horde::getFormData('name', '');
$email = Horde::getFormData('email', '');
$subject = Horde::getFormData('subject', '');
$message = Horde::getFormData('message', '');

/* Run through action handlers */
if (isset($HTTP_POST_VARS['actionID'])) {
    /* Translate non-int values into the correct int. */
    if (strcspn($HTTP_POST_VARS['actionID'], '0123456789')) {
        $HTTP_POST_VARS['actionID'] = $actions[$HTTP_POST_VARS['actionID']];
    }
    
    switch ($HTTP_POST_VARS['actionID']) {
    case HORDE_SEND_MESSAGE:
        if (!empty($HTTP_POST_VARS['subject']) && !empty($HTTP_POST_VARS['message'])) {
            include_once './lib/MIME/Message.php';
            
            $HTTP_POST_VARS['message'] = str_replace("\r\n", "\n", $HTTP_POST_VARS['message']);
            
            $mime = new MIME_Message();
            $text_part = new MIME_Part('text/plain',
                                       Text::wrap($HTTP_POST_VARS['message'], 80, "\n"));
            
            $mime->addPart($text_part);
            $msg = $mime->toString();
            
            $envelope['Message-ID'] = '<' . uniqid(time() . '.') . '@' .
                $HTTP_SERVER_VARS['SERVER_NAME'] . '>';
            $envelope['Date'] = date('r');
            $envelope['To'] = $horde['problems']['email'];
            if (!empty($email)) {
                if (!empty($name)) {
                    // need Mail_RFC822::writeAddress() here
                    $envelope['From'] = '"' . addslashes($name) . '" <' . $email . '>';
                } else {
                    $envelope['From'] = $email;
                }
                $envelope['Sender'] = 'horde-problem@' . $HTTP_SERVER_VARS['SERVER_NAME'];
            } else {
                $envelope['From'] = 'horde-problem@' . $HTTP_SERVER_VARS['SERVER_NAME'];
            }
            $recipients = $horde['problems']['email'];
            $envelope['Subject'] = _("[Problem Report]") . ' ' . $subject;
            $envelope = $mime->header($envelope);
            $envelope['User-Agent'] = 'Horde ' . HORDE_VERSION;
            
            include_once 'Mail.php';
            $mailer = Mail::factory($horde['mailer']['type'], $horde['mailer']['params']);
            if (!PEAR::isError($mailer->send($recipients, $envelope, $msg))) {
                /* We succeeded.  Print success message, load mailbox, quit. */
                returnToPage();
                exit;
            } else {
                $ACTION_TEXT = _("Describe the Problem");
            }
        } else {
            /* Something wasn't quite right. Strange. */
            $ACTION_TEXT = _("Describe the Problem");
        }
        break;
    
    case HORDE_NO_ACTION:
    default:
        returnToPage();
        exit;
        break;
    }
} else {
    $ACTION_TEXT = _("Describe the Problem");
}

$title = _("Problem Description");
$sidebar = false;
require $horde['horde']['paths']['templates'] . '/common-header.inc';

if ($browser->hasFeature('javascript')) {
    include $horde['horde']['paths']['templates'] . '/problem/problem.inc';
} else {
    include $horde['horde']['paths']['templates'] . '/problem/lynx_problem.inc';
}

require $horde['horde']['paths']['templates'] . '/common-footer.inc';
if ($browser->hasFeature('javascript')) {
    include $horde['horde']['paths']['templates'] . '/problem/javascript.inc';
}

?>
