<?php
// $Horde: horde/lib/User/sql.php,v 1.1 2000/08/28 03:45:54 chuck Exp $

require_once 'DB.php';

/**
 * The User_sql class provides a sql implementation of the Horde
 * user info system.
 *
 * @author   Chuck Hagenbuch <chuck@horde.org>
 * @version  $Revision: 1.1 $
 * @since    Horde 1.3
 */
class User_sql extends User {
    
    /** Hash containing connection parameters. */
    var $params = array();
    
    /** Handle for the current database connection. */
    var $db;
    
    /** Boolean indicating whether or not we're connected to the SQL server. */
    var $connected = false;
	
    
    /**
     * Constructs a new SQL permissions object.
     *
     * @param $params   A hash containing connection parameters.
     */
    function User_sql($params = array())
    {
        $this->params = $params;
    }
	
	
    /**
     * Attempts to open a persistent connection to the SQL server.
     *
     * @return USER_OK on success, USER_ERROR_* on failure.
     */
    function connect()
    {
        if (!$this->connected) {
            if (!is_array($this->params)) return USER_ERROR_PARAMS;
            if (!isset($this->params['phptype'])) return USER_ERROR_PARAMS;
            if (!isset($this->params['hostspec'])) return USER_ERROR_PARAMS;
            if (!isset($this->params['username'])) return USER_ERROR_PARAMS;
            if (!isset($this->params['password'])) return USER_ERROR_PARAMS;
            if (!isset($this->params['database'])) return USER_ERROR_PARAMS;
            if (!isset($this->params['table'])) return USER_ERROR_PARAMS;

            /* Connect to the SQL server using the supplied parameters. */
            $this->db = &DB::connect($this->params, true);
            if (DB::isError($this->db) || DB::isWarning($this->db)) {
                return USER_ERROR_CONNECT;
            }

            $this->connected = true;
        }

        return USER_OK;
    }
	
    /**
     * Disconnect from the SQL server and clean up the connection.
     *
     * @return true on success, false on failure.
     */
    function disconnect()
    {
        if ($this->connected) {
            $this->connected = false;
            return $this->db->disconnect();
        }

        return true;
    }
	
}
?>
