<?php
// $Horde: horde/lib/User.php,v 1.1 2000/08/28 03:45:53 chuck Exp $

/* Return codes */
define('USER_OK',               0);    // Operation succeeded
define('USER_ERROR',           -1);    // operation failed
define('USER_ERROR_PARAMS',    -2);    // Bad or missing parameters ($params)
define('USER_ERROR_CONNECT',   -3);    // Connection failure
define('USER_ERROR_AUTH',      -4);    // Authentication failure
define('USER_ERROR_EMPTY',     -5);    // Empty retrieval result

/**
 * The User:: class provides a common abstracted interface into the
 * various backends for the Horde user info system.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.1 $
 * @since   Horde 1.3
 */
class User {
    
    /**
     * Attempts to return a concrete User instance based on $driver.
     * 
     * @param $driver The type of concrete User subclass to return.
     *                This is based on the storage driver ($driver).  The
     *                code is dynamically included.
     * @param $params (optional) A hash containing any additional
     *                configuration or connection parameters a subclass
     *                might need.
     *
     * @return The newly created concrete User instance, or false
     *         on an error.
     */
    function factory($driver, $params = array())
    {
        if (empty($driver) || (strcasecmp($driver, 'none') == 0)) {
            return new User;
        }
        
        $classfile = dirname(__FILE__) . '/User/' . $driver . '.php';
        
        if (@is_readable($classfile)) {
            include_once $classfile;
            $class = 'User_' . $driver;
            return new $class($params);
        } else {
            return false;
        }
    }
	
    /**
     * Attempts to return a reference to a concrete User instance based on
     * $driver. It will only create a new instance if no User instance
     * with the same parameters currently exists.
     *
     * This should be used if multiple permissions sources (and, thus,
     * multiple User instances) are required.
     *
     * This method must be invoked as: $var = &User::singleton()
     *
     * @param $driver The type of concrete User subclass to return.
     *                This is based on the storage driver ($driver). The
     *                code is dynamically included.
     * @param $params (optional) A hash containing any additional
     *                configuration or connection parameters a subclass
     *                might need.
     *
     * @return The concrete User reference, or false on an error.
     */
    function &singleton($driver, $user = '', $params = array())
    {
        static $instances;

        if (!isset($instances)) $instances = array();

        $signature = md5($driver . '][' . $user . '][' . implode('][', $params));
        if (!isset($instances[$signature])) {
            $instances[$signature] = User::factory($driver, $user, $params);
        }

        return $instances[$signature];
    }
	
}
?>
