<?php
// $Horde: horde/lib/Prefs/mysql.php,v 1.9 2000/12/21 06:39:19 max Exp $

/**
 * Preferences storage implementation for PHP's MySQL implementation.
 *
 * Required values for $params:
 *      'hostspec'      The hostname of the database server.
 *      'username'      The username with which to connect to the database.
 *      'password'      The password associated with 'username'.
 *      'database'      The name of the database.
 *      'table'         The name of the preferences table in 'database'.
 *
 * The table structure for the preferences is as follows:
 *
 *  create table user_webmail_prefs (
 *      uid             char(32) not null,
 *      pref_name       char(32) not null,
 *      pref_value      text null,
 *      primary key (uid, pref_name)
 *  );
 *
 * @author  Max Kalika <max@horde.org>
 * @author  Jon Parise <jon@csh.rit.edu>
 * @version $Revision: 1.9 $
 * @since   Horde 1.3
 */

class Prefs_mysql extends Prefs {

    /** Hash containing connection parameters. */
    var $params = array();

    /** Handle for the current database connection. */
    var $db = '';

    /** Boolean indicating whether or not we're connected to the SQL server. */
    var $connected = false;

    /**
     * Constructs a new SQL preferences object.
     *
     * @param $user     The user who owns these preferences.
     * @param $password The password associated with $user. (unused)
     * @param $params   A hash containing connection parameters.
     */
    function Prefs_mysql($user, $password = '', $params = array())
    {
        $this->user = $user;
        $this->params = $params;
    }

    /**
     * Opens a connection to the SQL server.
     *
     * @return          PREFS_OK on success, PREFS_ERROR_* on failure.
     */
    function connect()
    {
        if (!$this->connected) {
            if (!is_array($this->params)) return PREFS_ERROR_PARAMS;
            if (!isset($this->params['hostspec'])) return PREFS_ERROR_PARAMS;
            if (!isset($this->params['username'])) return PREFS_ERROR_PARAMS;
            if (!isset($this->params['password'])) return PREFS_ERROR_PARAMS;
            if (!isset($this->params['database'])) return PREFS_ERROR_PARAMS;
            if (!isset($this->params['table'])) return PREFS_ERROR_PARAMS;

            /* Connect to the SQL server using the supplied parameters. */
            $this->db = mysql_pconnect($this->params['hostspec'],
                $this->params['username'], $this->params['password']);
            if (!$this->db) {
                return PREFS_ERROR_CONNECT;
            } else if(!mysql_select_db($this->params['database'])) {
                return PREFS_ERROR_CONNECT;
            }

            $this->connected = true;
        }

        return PREFS_OK;
    }

    /**
     * Disconnect from the SQL server and clean up the connection.
     *
     * @return      true on success, false on failure.
     */
    function disconnect()
    {
        /*
         * Note that mysql_close() really has no effect when using persistant
         * connections.  We simply call it here for completeness.
         */
        if ($this->connected) {
            $this->connected = false;
            return mysql_close($this->db);
        }

        return true;
    }

    /**
     * Retrieves the requested set of preferences from the user's database
     * entry.
     *
     * @param $prefs    (optional) An array listing the preferences to
     *                  retrieve.  If not specified, retrieve all of the
     *                  preferences listed in the $prefs hash.
     *
     * @return          PREFS_OK on success, PREFS_ERROR_* on failure.
     */
    function retrieve($prefs = array())
    {
        /* If we're not already connected, invoke the connect() method. */
        if (!$this->connected) {
            if ($this->connect() != PREFS_OK) return PREFS_ERROR_CONNECT;
        }

        /*
         * If a list of preferences to retrieve hasn't been provided in
         * $prefs, assume all preferences are desired.
         */
        if (count($prefs) == 0) {
            $prefs = $this->listAll();
        }
        if (!is_array($prefs) || (count($prefs) == 0)) return PREFS_ERROR;

        /* Build the SQL query. */
        $query = 'select pref_name, pref_value from ';
        $query .= $this->params['table'] . ' ';
        $query .= "where uid = '" . $this->user . "'";

        /* Execute the query. */
        $result = mysql_query($query, $this->db);

        if (isset($result) && $result) {
            $rows = mysql_num_rows($result);
            if ($rows < 1) return PREFS_ERROR_EMPTY;

            /*
             * Set the requested values in the $this->prefs hash based on
             * the contents of the SQL result.
             *
             * Note that Prefs::setValue() can't be used here because of the
             * check for the "changeable" bit.  We want to override that
             * check when populating the $this->prefs hash from the SQL
             * server.
             */
            for ($i = 0; $i < $rows; $i++) {
                $row = mysql_fetch_array($result);
                $name = trim($row['pref_name']);
                $value = trim($row['pref_value']);
                if (in_array($name, $prefs)) {
                    $this->prefs[$name]['val'] = $value;
                    $this->setDirty($name, false);
                }
            }
            mysql_free_result($result);        

        } else return PREFS_ERROR_EMPTY;

        return PREFS_OK;
    }

    /**
     * Stores preferences to SQL server.
     *
     * @param $prefs    (optional) An array listing the preferences to be
     *                  stored.  If not specified, store all of the
     *                  preferences listed in the $prefs hash.
     *
     * @return bool     PREFS_OK on success, PREFS_ERROR_* on failure.
     */
    function store($prefs = array())
    {
        /* If we're not already connected, invoke the connect(). */
        if (!$this->connected) {
            if ($this->connect() != PREFS_OK) return PREFS_ERROR_CONNECT;
        }

        /*
         * If a list of preferences to store hasn't been provided in
         * $prefs, assume all preferences are desired.
         */
        if (count($prefs) == 0) {
            $prefs = $this->listAll();
        }
        if (!is_array($prefs)) return PREFS_ERROR;

        /* Check for any "dirty" preferences. */
        $dirty_prefs = array();
        foreach ($prefs as $pref) {
            if ($this->isDirty($pref)) {
                $dirty_prefs[] = $pref;
            }
        }

        /*
         * If no "dirty" preferences were found, there's no need to update
         * the SQL server.  Exit successfully.
         */
        if (count($dirty_prefs) == 0) {
            return PREFS_OK;
        }

        /*
         * Loop through the "dirty" preferences.  If our attempt to insert
         * a new row fails, try to update an existing one.
         */
        foreach ($dirty_prefs as $name) {
            $value = addslashes($this->getValue($name));

            /* Attempt an insert. */
            $query = 'insert into ' . $this->params['table'] . ' ';
            $query .= '(uid, pref_name, pref_value) ';
            $query .= "values('$this->user', '$name', '$value')";
            $result = @mysql_query($query, $this->db);

            /* If the insert failed, attempt an update. */
            if (!$result) {
                $query = 'update ' . $this->params['table'] . ' ';
                $query .= "set pref_value = '$value' where uid = ";
                $query .= "'$this->user' and pref_name = '$name'";
                $result = @mysql_query($query, $this->db);

                /* Return an error if the update fails, too. */
                if (!$result) return PREFS_ERROR;
            }

            /* Mark this preference as "clean" now. */
            $this->setDirty($name, false);
        }

        return PREFS_OK;
    }

}
?>
