<?php
// $Horde: horde/lib/Perms/sql.php,v 1.4 2000/08/25 03:08:14 chuck Exp $

require_once 'DB.php';

/**
 * The Perms_sql class provides a sql implementation of the Horde
 * permissions system.
 *
 * @author   Chuck Hagenbuch <chuck@horde.org>
 * @version  $Revision: 1.4 $
 * @since    Horde 1.3
 */
class Perms_sql extends Perms {
    
    /** Hash containing connection parameters. */
    var $params = array();
    
    /** Handle for the current database connection. */
    var $db;
    
    /** Boolean indicating whether or not we're connected to the SQL server. */
    var $connected = false;
	
    
    /**
     * Constructs a new SQL permissions object.
     *
     * @param $params   A hash containing connection parameters.
     */
    function Perms_sql($params = array())
    {
        $this->params = $params;
    }
	
	
    /**
     * Attempts to open a persistent connection to the SQL server.
     *
     * @return PERMS_OK on success, PERMS_ERROR_* on failure.
     */
    function connect()
    {
        if (!$this->connected) {
            if (!is_array($this->params)) return PERMS_ERROR_PARAMS;
            if (!isset($this->params['phptype'])) return PERMS_ERROR_PARAMS;
            if (!isset($this->params['hostspec'])) return PERMS_ERROR_PARAMS;
            if (!isset($this->params['username'])) return PERMS_ERROR_PARAMS;
            if (!isset($this->params['password'])) return PERMS_ERROR_PARAMS;
            if (!isset($this->params['database'])) return PERMS_ERROR_PARAMS;
            if (!isset($this->params['table'])) return PERMS_ERROR_PARAMS;

            /* Connect to the SQL server using the supplied parameters. */
            $this->db = &DB::connect($this->params, true);
            if (DB::isError($this->db) || DB::isWarning($this->db)) {
                return PERMS_ERROR_CONNECT;
            }

            $this->connected = true;
        }

        return PERMS_OK;
    }
	
    /**
     * Disconnect from the SQL server and clean up the connection.
     *
     * @return true on success, false on failure.
     */
    function disconnect()
    {
        if ($this->connected) {
            $this->connected = false;
            return $this->db->disconnect();
        }

        return true;
    }
	
    /**
	 * Find out what rights the given user has to the specified object.
	 * 
     * @param $objectpath The full path to the piece of
     *                    content/whatever to check the permissions
     *                    of.
	 * @param $user The user to check for.
	 * @param $default What to return if nothing is found in the db.
	 * 
	 * @return Any permissions the user has, or $default if there
	 *         are none.
	 */
    function check ($objectpath, $user, $default = PERMS_NONE)
    {
		if ($this->connect() != PERMS_OK) return $default;
		
		if (empty($objectpath))
			return $default;
		
		if (!is_array($objectpath))
			$objectpath = explode($this->path_seperator, $objectpath);
		
        /* Build the SQL query. */
        $query = 'SELECT perm FROM ' . $this->params['table'];
        $query .= " WHERE object = '" . array_pop($objectpath) . "' AND user = '" . $user . "'";
        
        /* Execute the query. */
        $result = $this->db->query($query);
		
        if (is_object($result)) {
            $row = $result->fetchRow(DB_GETMODE_ASSOC);
            if ($row && (isset($row['perm']))) {
                $result->free();
                return $row['perm'];
            } else {
				$result->free();
				return $this->check($objectpath, $user, $default);
			}
        } else {
			return PERMS_ERROR;
		}
    }
	
    /**
     * Add the permission(s) specified to the given user and object.
     *
     * @param $object The piece of content/whatever to add
     *                permissions to.
	 * @param $user The user to add permissions for.
     * @param $perm The permission to be added.
     */
    function addPerms ($object, $user, $perm)
    {
        if ($this->connect() != PERMS_OK) return false;
        
        /* Build the SQL query. */
        $query = "UPDATE " . $this->params['table'] . ' SET perms = perms | ' . $perm;
        $query .= "where user = '" . $user . "'";
        
        /* Execute the query. */
        $result = $this->db->query($query);
        
        // check $result now...
        return PERMS_OK;
    }
    
	/**
     * Remove the permission(s) specified from the given user and object.
     *
     * @param $object The piece of content/whatever to remove
     *                permissions from.
	 * @param $user The user to remove permissions from.
     * @param $perm The permission to be removed.
     */
    function removePerms ($object, $user, $perm)
    {
        if ($this->connect() != PERMS_OK) return false;
        
        /* Build the SQL query. */
        $query = "UPDATE " . $this->params['table'] . ' SET perms = perms & ~' . $perm;
        $query .= "where user = '" . $user . "'";
        
        /* Execute the query. */
        $result = $this->db->query($query);
        
        // check $result now...
        return PERMS_OK;
    }
    
}
?>
