<?php

class MIME_Message {
    
    var $separator;
    var $parts;
    var $defaultServer;
    
    function MIME_Message($defaultServer = null)
    {
        $this->parts = array();
        $this->separator = '-MOQ' . (string)date('U') . md5(uniqid(rand()));
        if (!isset($defaultServer)) {
            $this->defaultServer = $GLOBALS['HTTP_SERVER_VARS']['SERVER_NAME'];
        } else {
            $this->defaultServer = $defaultServer;
        }
    }
    
    
    function addPart($part)
    {
        $this->parts[] = $part;
    }
    
    function encode($envelope)
    {
        include_once dirname(__FILE__) . '.php';
        global $HTTP_ACCEPT_CHARSET;
        
        if (!empty($HTTP_ACCEPT_CHARSET)) {
            $charsets = explode(',', $HTTP_ACCEPT_CHARSET);
            if (!empty($charsets[0])) {
                $charset = trim($charsets[0]);
            }
        }
        if (empty($charset)) $charset = 'ISO-8859-1';
        
        foreach ($envelope as $key => $val) {
            if ($key == 'To' || $key == 'Cc' || $key == 'Bcc' || $key == 'From') {
                $envelope[$key] = MIME::encodeAddress($val, $charset, $this->defaultServer);
            } else {
                $envelope[$key] = MIME::encode($val, $charset);
            }
        }
        return $envelope;
    }
    
    function header($envelope = array())
    {
        $envelope['MIME-Version'] = '1.0';
        $envelope = $this->encode($envelope);
        if (count($this->parts) > 1) {
            $envelope['Content-Type'] = 'multipart/mixed; boundary="' . $this->separator . '"';
        } else {
            $part = $this->parts[0];
            $envelope = $part->header($envelope);
        }
        return $envelope;
    }
    
    function toString()
    {
        $message = '';
        if (count($this->parts) == 1) {
            /* Only one part, no need to make a multipart message */
            $part = $this->parts[0];
            $message = $part->getContents();
        } else {
            /* Output the multipart MIME message */
            $message = "This message is in MIME format.\n";
            foreach ($this->parts as $part) {
                $message .= "\n--$this->separator\n";
                $message .= $part->toString();
            }
            $message .= "\n--$this->separator--\n";
        }
        return $message;
    }
    
}


class MIME_Part {
    
    var $type = 'application';
    var $subtype = 'octet-stream';
    var $contents = '';
    var $transferEncoding = '7bit';
    var $description = '';
    var $name = '';
    var $charset = '';
    
    
    function MIME_Part($mimetype = null, $contents = null)
    {
        if (isset($mimetype)) $this->setType($mimetype);
        if (isset($contents)) $this->contents = $contents;
    }
    
    
    function setType($mimetype)
    {
        list($this->type, $this->subtype) = explode('/', $mimetype);
    }
    
    function setName($name)
    {
        $this->name = $name;
    }
    
    function setContents($contents)
    {
        $this->contents = $contents;
    }
    
    function appendContents($contents)
    {
        $this->contents .= $contents;
    }
    
    function getContents()
    {
        return $this->contents;
    }
    
    function setTransferEncoding($encoding)
    {
        $this->transferEncoding = $encoding;
    }
    
    function header($envelope)
    {
        $envelope['Content-Type'] = strtolower($this->type . '/' . $this->subtype);
        if (!empty($this->name))
            $envelope['Content-Type'] .= '; name="' . $this->name . '"';
        
        $this->setEncoding();
        
        if (($this->type == 'text') && (!empty($this->charset))) {
            $envelope['Content-Type'] .= '; charset=' . $this->charset;
        }
        $envelope['Content-Transfer-Encoding'] = $this->transferEncoding;
        
        if ($this->name != '')
            $envelope['Content-Disposition'] = "inline; filename=\"$this->name\"";
        if ($this->description != '')
            $envelope['Content-Description'] = $this->description;
        
        return $envelope;
    }
    
    function toString()
    {
        $part = '';
        $headers = $this->header(array());
        while (list($key, $val) = each($headers))
            $part .= $key . ': ' . $val . "\n";
        
        return $part . "\n" . $this->getContents();
    }
    
    function setEncoding()
    {
        $text = str_replace("\n", ' ', $this->contents);
        if ($this->type == 'text' && imap_8bit($text) != $text) {
            $this->transferEncoding = '8bit';
            
            global $language, $nls, $HTTP_SERVER_VARS;
            
            if (!empty($nls['charsets'][$language])) {
                $this->charset = $nls['charsets'][$language];
            } else if (!empty($HTTP_SERVER_VARS['HTTP_ACCEPT_CHARSET'])) {
                $charsets = explode(',', $HTTP_SERVER_VARS['HTTP_ACCEPT_CHARSET']);
                if (!empty($charsets[0])) {
                    $this->charset = trim($charsets[0]);
                }
            }
            
            if (empty($this->charset)) $charset = 'ISO-8859-1';
        }
    }
    
}
?>
