<?php
// $Horde: horde/lib/MIME.php,v 1.51 2001/01/08 22:52:42 chuck Exp $

define('MIME_DEFAULT_CHARSET', 'us-ascii');
define('MIME_DEFAULT_ENCODING', ENC7BIT);
define('MIME_DEFAULT_DESCRIPTION', '[' . _("no description") . ']');

$mime_types =
array(
      TYPETEXT => 'text', 'text' => TYPETEXT,
      TYPEMULTIPART => 'multipart', 'multipart' => TYPEMULTIPART,
      TYPEMESSAGE => 'message', 'message' => TYPEMESSAGE,
      TYPEAPPLICATION => 'application', 'application' => TYPEAPPLICATION,
      TYPEAUDIO => 'audio', 'audio' => TYPEAUDIO,
      TYPEIMAGE => 'image', 'image' => TYPEIMAGE,
      TYPEVIDEO => 'video', 'video' => TYPEVIDEO,
      TYPEOTHER => 'unknown', 'unknown' => TYPEOTHER
      );

$mime_encodings = 
array(
      ENC7BIT => '7bit', '7bit' => ENC7BIT,
      ENC8BIT => '8bit', '8bit' => ENC8BIT,
      ENCBINARY => 'binary', 'binary' => ENCBINARY,
      ENCBASE64 => 'base64', 'base64' => ENCBASE64,
      ENCQUOTEDPRINTABLE => 'quoted-printable', 'quoted-printable' => ENCQUOTEDPRINTABLE,
      ENCOTHER => 'unknown', 'unknown' => ENCOTHER
      );


/**
 * The MIME:: class provides methods for dealing with MIME standards.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.51 $
 * @since   Horde 1.3
 */
class MIME {
    
    function is8bit($string)
    {
        if (is_string($string)) {
            for ($i = 0; $i < strlen($string); $i++) {
                if (ord($string[$i]) >> 7)
                    return true;
            }
            return false;
        }
        return false;
    }
    
    function encode($text, $charset, $outer = true)
    {
        if (MIME::is8bit($text)) {
            if (((strlen($text) * 3) + strlen($charset) + 7) > 76) {
                $text = MIME::encode(substr($text, 0, (23 - strlen($charset))), $charset) . MIME::encode(substr($text, (23 - strlen($charset))), $charset, false);
            } else {
                // FIXME: dependency on imap module.
                $text = "=?$charset?Q?" . strtr(trim(imap_8bit($text)), ' ', '_') . "?=\n\t";
            }
        }
        
        // if this is the final iteration, take off any trailing
        // newline/tab chars.
        if ($outer && (substr($text, -2) == "\n\t"))
            $text = substr($text, 0, -2);
        
        return $text;
    }
    
    function encodeAddress($text, $charset, $defserver)
    {
        include_once 'Mail/rfc822.php';
        
        $addr_arr = Mail_rfc822::parseAddressList($text, $defserver, false);
        $text = '';
        if (is_array($addr_arr)) {
            foreach ($addr_arr as $addr) {
                if (empty($addr->personal)) $personal = '';
                else $personal = MIME::encode($addr->personal, $charset);
                if (strlen($text) != 0) $text .= ', ';
                // FIXME: dependency on imap module
                $text .= MIME::trimEmailAddress(imap_rfc822_write_address($addr->mailbox, $addr->host, $personal));
            }
        }
        return $text;
    }
    
    /* Function to decode a MIME-encoded string, returns the original string, if not MIME */
    function decode($string)
    {
        $pos = strpos($string, '=?');
        if ($pos === false) {
            return $string;
        }
        
        // take out any spaces between multiple encoded words
        $string = preg_replace('|\?=\s=\?|', '?==?', $string);
        
        $preceding = substr($string, 0, $pos); // save any preceding text
        
        $search = substr($string, $pos + 2, 75); // the mime header spec says this is the longest a single encoded word can be
        $d1 = strpos($search, '?');
        if (!is_int($d1)) {
            return $string;
        }
        
        $charset = substr($string, $pos + 2, $d1);
        $search = substr($search, $d1 + 1);
        
        $d2 = strpos($search, '?');
        if (!is_int($d2)) {
            return $string;
        }
        
        $encoding = substr($search, 0, $d2);
        $search = substr($search, $d2+1);
        
        $end = strpos($search, '?=');
        if (!is_int($end)) {
            return $string;
        }
        
        $encoded_text = substr($search, 0, $end);
        $rest = substr($string, (strlen($preceding . $charset . $encoding . $encoded_text) + 6));
        
        switch ($encoding) {
        case 'Q':
        case 'q':
            $encoded_text = str_replace('_', '%20', $encoded_text);
            $encoded_text = str_replace('=', '%', $encoded_text);
            $decoded = urldecode($encoded_text);
            
            if (strtolower($charset) == 'windows-1251') {
                $decoded = convert_cyr_string($decoded, 'w', 'k');
            }
            break;
            
        case 'B':
        case 'b':
            $decoded = urldecode(base64_decode($encoded_text));
            
            if (strtolower($charset) == 'windows-1251') {
                $decoded = convert_cyr_string($decoded, 'w', 'k');
            }
            break;
            
        default:
            $decoded = '=?' . $charset . '?' . $encoding . '?' . $encoded_text . '?=';
            break;
        }
        
        return $preceding . $decoded . MIME::decode($rest);
    }
    
    /**
     * If an email address has no personal information, get rid of any
     * angle brackets (<>) around it.
     *
     * @param string $address	The address to trim.
     * @return string			The trimmed address.
     */
    function trimEmailAddress($address)
    {
        $address = trim($address);
        if ((substr($address, 0, 1) == '<') && (substr($address, -1) == '>')) {
            $address = substr($address, 1, -1);
        }
        return $address;
    }
    
}
?>
