<?php
// $Horde: horde/lib/Connection/sql.php,v 1.2 2000/12/21 06:39:17 max Exp $

require_once 'DB.php';

/**
 * Connection tracking implementation for PHP's PEAR database abstraction
 * layer.
 *
 * Required values for $params:
 *      'phptype'       The database type (ie. 'pgsql', 'mysql, etc.).
 *      'hostspec'      The hostname of the database server.
 *      'username'      The username with which to connect to the database.
 *      'password'      The password associated with 'username'.
 *      'database'      The name of the database.
 *      'table'         The name of the connections table in 'database'.
 * 
 * Required by some database implementations:
 *      'options'       Additional options to pass to the database.
 *      'tty'           The TTY on which to connect to the database.
 *      'port'          The port on which to connect to the database.
 *
 * Optional value for $params:
 *      'timeout'       The period (in seconds) after which an id is purged.
 *
 * The table structure for the connections is as follows:
 *
 *  create table connections (
 *      addr        varchar(8)  not null,
 *      conn_id     varchar(32) not null,
 *      conn_ts     int(14)     not null,
 *      primary key (addr, conn_id)
 *  );
 *
 * @author  Max Kalika <max@horde.org>
 * @version $Revision: 1.2 $
 * @since   Horde 1.3
 */

class Connection_sql extends Connection {

    /** Handle for the current database connection. */
    var $db = '';

    /** Boolean indicating whether or not we're connected to the SQL server. */
    var $connected = false;

    /**
     * Constructs a new SQL connection object.
     *
     * @param $params   A hash containing connection parameters.
     */
    function Connection_sql($params = array())
    {
        $this->params = $params;

        /* Set timeout to 24 hours if not specified. */
        if(!isset($this->params['timeout'])) {
            $this->params['timeout'] = 86400;
        }
    }

    /**
     * Opens a connection to the SQL server.
     *
     * @return bool         CONN_OK on success, CONN_ERROR_* on failure.
     */
    function connect()
    {
        if (!$this->connected) {
            if (!is_array($this->params)) return CONN_ERROR_PARAMS;
            if (!isset($this->params['phptype'])) return CONN_ERROR_PARAMS;
            if (!isset($this->params['hostspec'])) return CONN_ERROR_PARAMS;
            if (!isset($this->params['username'])) return CONN_ERROR_PARAMS;
            if (!isset($this->params['password'])) return CONN_ERROR_PARAMS;
            if (!isset($this->params['database'])) return CONN_ERROR_PARAMS;
            if (!isset($this->params['table'])) return CONN_ERROR_PARAMS;

            /* Connect to the SQL server using the supplied parameters. */
            $this->db = &DB::connect($this->params, true);
            if (DB::isError($this->db) || DB::isWarning($this->db)) {
                return CONN_ERROR_CONNECT;
            }

            $this->connected = true;
        }

        return CONN_OK;
    }

    /**
     * Disconnect from the SQL server and clean up the connection.
     *
     * @return bool         true on success, false on failure.
     */
    function disconnect()
    {
        if ($this->connected) {
            $this->connected = false;
            return $this->db->disconnect();
        }

        return true;
    }

    /**
     * Deletes all expired connection id's from the SQL server.
     *
     * @return bool         CONN_OK on success, CONN_ERROR_* on failure.
     */
    function purge()
    {
        /* If we're not already connected, invoke the connect(). */
        if (!$this->connected) {
            if ($this->connect() != CONN_OK) return CONN_ERROR_CONNECT;
        }

        /* Build SQL query. */
        $query = 'delete from ' . $this->params['table'] . ' where ';
        $query .= 'conn_ts < ' . (time() - $this->params['timeout']);

        $result = @mysql_query($query, $this->db);

        /* Return an error if the update fails, too. */
        if (!$result) return CONN_ERROR;

        return CONN_OK;
    }

    function exists($connID)
    {
        /* If we're not already connected, invoke the connect(). */
        if (!$this->connected) {
            if ($this->connect() != CONN_OK) return CONN_ERROR_CONNECT;
        }

        /* Build SQL query. */
        $query = 'select conn_id from ' . $this->params['table'] . ' where ';
        $query .= "addr = '" . $this->hexRemoteAddr() . "' ";
        $query .= "and conn_id = '$connID'";

        $result = $this->db->query($query);

        if (isset($result) && is_object($result)) {
            $row = $result->fetchRow();
        }

        if (!$row) return false;
        return true;
    }

    function add($connID)
    {
        /* If we're not already connected, invoke the connect(). */
        if (!$this->connected) {
            if ($this->connect() != CONN_OK) return CONN_ERROR_CONNECT;
        }

        /* Build SQL query. */
        $query = 'insert into ' . $this->params['table'] . ' ';
        $query .= "values('" . $this->hexRemoteAddr() . "', ";
        $query .= "'$connID', " . time() . ")";

        $result = $this->db->query($query);

        /* Return an error if the update fails, too. */
        if (!$result) return CONN_ERROR;

        return CONN_OK;
    }
}
?>
