<?php
// $Horde: horde/lib/Browser.php,v 1.11 2001/01/10 19:24:31 chuck Exp $

/**
 * The Browser:: class provides capability information for the current
 * web client. Browser identification is performed by examining the
 * $HTTP_USER_AGENT environmental variable provide by the web server.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @author  Jon Parise <jon@csh.rit.edu>
 * @version $Revision: 1.11 $
 * @since   Horde 1.3
 */
class Browser {
    
    /**
     * General version numbers
     */
    var $majorVersion = 0;
    var $minorVersion = 0;
    
    /**
     * Browser name
     */
    var $browser = '';
    
    /**
     * Full user agent
     */
    var $agent = '';
    
    /**
     * Features
     */
    var $features = array('html'       => true,
                          'hdml'       => false,
                          'wml'        => false,
                          'images'     => true,
                          'frames'     => true,
                          'tables'     => true,
                          'java'       => true,
                          'javascript' => true);
    
    /**
     * Quirks
     */
    var $quirks = array('must_cache_forms'         => false,
                        'avoid_popup_windows'      => false,
                        'cache_ssl_downloads'      => false,
                        'break_disposition_header' => false);
    
    
    /**
     * Constructor
     */
    function Browser($userAgent = null)
    {
        $this->match($userAgent);
    }
    
    function match($userAgent = null)
    {
        if (!isset($userAgent)) {
            if (isset($GLOBALS['HTTP_SERVER_VARS']['HTTP_USER_AGENT'])) {
                $this->agent = trim($GLOBALS['HTTP_SERVER_VARS']['HTTP_USER_AGENT']);
            }
        } else {
            $this->agent = $userAgent;
        }
        
        if (!empty($this->agent)) {
            if ((preg_match('|MSIE ([0-9.]+)|', $this->agent, $version)) ||
                (preg_match('|Internet Explorer/([0-9.]+)|', $this->agent, $version))) {
                
                $this->setBrowser('msie');
                $this->setQuirk('cache_ssl_downloads');
                
                list($this->majorVersion, $this->minorVersion) = explode('.', $version[1]);
                switch($this->majorVersion) {
                case 5:
                    $this->setFeature('javascript', 1.4);
                    if ($this->minorVersion == 5) {
                        $this->setQuirk('break_disposition_header');
                    }
                    break;
                case 4:
                    $this->setFeature('javascript', 1.2);
                    break;
                case 3:
                    $this->setFeature('javascript', 1.1);
                    $this->setQuirk('avoid_popup_windows');
                    break;
                }
                
            } elseif (preg_match('|ANTFresco/([0-9]+)|', $this->agent, $version)) {
                $this->setBrowser('fresco');
                $this->setFeature('javascript', 1.1);
                $this->setQuirk('avoid_popup_windows');
                
            } elseif (preg_match('|Mozilla/([0-9.]+)|', $this->agent, $version)) {
                $this->setBrowser('netscape');
                $this->setQuirk('must_cache_forms');
                
                list($this->majorVersion, $this->minorVersion) = explode('.', $version[1]);
                switch($this->majorVersion) {
                case 5:
                    $this->setFeature('javascript', 1.4);
                    break;
                case 4:
                    $this->setFeature('javascript', 1.3);
                    break;
                case 3:
                default:
                    $this->setFeature('javascript', 1);
                    break;
                }
                
            } elseif (preg_match('|Lynx/([0-9]+)|', $this->agent, $version)) {
                $this->setBrowser('lynx');
                $this->setFeature('images', false);
                $this->setFeature('frames', false);
                $this->setFeature('javascript', false);
                $this->setQuirk('avoid_popup_windows');
                
            } elseif (preg_match('|Links \(([0-9]+)|', $this->agent, $version)) {
                $this->setBrowser('links');
                $this->setFeature('images', false);
                $this->setFeature('frames', false);
                $this->setFeature('javascript', false);
                $this->setQuirk('avoid_popup_windows');
                
            } elseif (preg_match('|Konqueror/([0-9]+)|', $this->agent, $version)) {
                $this->setBrowser('konqueror');
                $this->setFeature('javascript', false);
                
            } elseif (preg_match('|HotJava/([0-9]+)|', $this->agent, $version)) {
                $this->setBrowser('hotjava');
                $this->setFeature('javascript', false);
                
            } elseif (preg_match('|UP|', $this->agent, $version) ||
                      preg_match('|Wap|', $this->agent, $version)) {
                $this->setBrowser('wap');
                $this->setFeature('html', false);
                $this->setFeature('hdml');
                $this->setFeature('wml');
            }
        }
    }
    
    
    function setBrowser($browser)
    {
        $this->browser = $browser;
    }
    
    function isBrowser($browser)
    {
        return ($this->browser === $browser);
    }
    
    function getBrowser()
    {
        return $this->browser;
    }
    
    function setQuirk($quirk, $value = true)
    {
        $this->quirks[$quirk] = $value;
    }
    
    function hasQuirk($quirk)
    {
        return in_array($quirk, $this->quirks);
    }
    
    function getQuirk($quirk)
    {
        return isset($this->quirks[$quirk]) ? $this->quirks[$quirk] : null;
    }
    
    function setFeature($feature, $value = true)
    {
        $this->features[$feature] = $value;
    }
    
    function hasFeature($feature)
    {
        return in_array($feature, $this->features);
    }
    
    function getFeature($feature)
    {
        return isset($this->features[$feature]) ? $this->features[$feature] : null;
    }
    
}
?>
